/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.Closeable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.impl.subscriber.BookKeeper;
import org.apache.sling.distribution.journal.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class Announcer
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Announcer.class);
    private final BookKeeper bookKeeper;
    private final Consumer<Messages.DiscoveryMessage> sender;
    private final String subSlingId;
    private final String subAgentName;
    private final Set<String> pubAgentNames;
    private final boolean editable;
    private final int maxRetries;
    private final ScheduledExecutorService executor;

    public Announcer(String subSlingId, String subAgentName, Set<String> pubAgentNames, Consumer<Messages.DiscoveryMessage> disSender, BookKeeper bookKeeper, int maxRetries, boolean editable, int announceDelay) {
        this.subSlingId = Objects.requireNonNull(subSlingId);
        this.subAgentName = Objects.requireNonNull(subAgentName);
        this.pubAgentNames = Objects.requireNonNull(pubAgentNames);
        this.sender = Objects.requireNonNull(disSender);
        this.bookKeeper = Objects.requireNonNull(bookKeeper);
        this.maxRetries = maxRetries;
        this.editable = editable;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(this, 0L, announceDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        LOG.debug("Sending discovery message for agent {}", (Object)this.subAgentName);
        try {
            Messages.DiscoveryMessage msg = this.createDiscoveryMessage();
            this.sender.accept(msg);
        }
        catch (Exception e) {
            LOG.info("Failed to send discovery message for agent {}, {}", new Object[]{this.subAgentName, e.getMessage(), e});
        }
    }

    private Messages.DiscoveryMessage createDiscoveryMessage() {
        long offset = this.bookKeeper.loadOffset();
        Messages.SubscriberConfiguration subscriberConfiguration = Messages.SubscriberConfiguration.newBuilder().setEditable(this.editable).setMaxRetries(this.maxRetries).build();
        Messages.DiscoveryMessage.Builder disMsgBuilder = Messages.DiscoveryMessage.newBuilder().setSubSlingId(this.subSlingId).setSubAgentName(this.subAgentName).setSubscriberConfiguration(subscriberConfiguration);
        for (String pubAgentName : this.pubAgentNames) {
            disMsgBuilder.addSubscriberState(this.subscriberState(pubAgentName, offset));
        }
        return disMsgBuilder.build();
    }

    private Messages.SubscriberState subscriberState(String pubAgentName, long offset) {
        int retries = this.bookKeeper.getRetries(pubAgentName);
        return Messages.SubscriberState.newBuilder().setPubAgentName(pubAgentName).setRetries(retries).setOffset(offset).build();
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

