/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Topics.class})
@Designate(ocd=TopicsConfiguration.class)
public class Topics {
    private static final Logger LOG = LoggerFactory.getLogger(Topics.class);
    public static final String PACKAGE_TOPIC = "aemdistribution_package";
    public static final String DISCOVERY_TOPIC = "aemdistribution_discovery";
    public static final String STATUS_TOPIC = "aemdistribution_status";
    public static final String COMMAND_TOPIC = "aemdistribution_command";
    public static final String EVENT_TOPIC = "aemdistribution_event";
    private String discoveryTopic = "aemdistribution_discovery";
    private String packageTopic = "aemdistribution_package";
    private String statusTopic = "aemdistribution_status";
    private String commandTopic = "aemdistribution_command";
    private String eventTopic = "aemdistribution_event";

    @Activate
    public void activate(TopicsConfiguration config) {
        this.packageTopic = config.packageTopic();
        this.discoveryTopic = config.discoveryTopic();
        this.statusTopic = config.statusTopic();
        this.commandTopic = config.commandTopic();
        this.eventTopic = config.eventTopic();
        LOG.info("Topics service started with packageTopic '{}' discoveryTopic '{}' statusTopic '{}' eventTopic '{}' commandTopic '{}'", new Object[]{this.packageTopic, this.discoveryTopic, this.statusTopic, this.eventTopic, this.commandTopic});
    }

    public String getPackageTopic() {
        return this.packageTopic;
    }

    public String getDiscoveryTopic() {
        return this.discoveryTopic;
    }

    public String getStatusTopic() {
        return this.statusTopic;
    }

    public String getCommandTopic() {
        return this.commandTopic;
    }

    public String getEventTopic() {
        return this.eventTopic;
    }

    @ObjectClassDefinition(name="Apache Sling Journal based Distribution - Topics")
    public static @interface TopicsConfiguration {
        @AttributeDefinition(name="Packages Topic", description="The topic for package messages.")
        public String packageTopic() default "aemdistribution_package";

        @AttributeDefinition(name="Discovery Topic", description="The topic for discovery messages.")
        public String discoveryTopic() default "aemdistribution_discovery";

        @AttributeDefinition(name="Status Topic", description="The topic for status messages.")
        public String statusTopic() default "aemdistribution_status";

        @AttributeDefinition(name="Command Topic", description="The topic for command messages.")
        public String commandTopic() default "aemdistribution_command";

        @AttributeDefinition(name="Event Topic", description="The optional topic for event messages. If the topic is blank, no event message is sent.")
        public String eventTopic() default "aemdistribution_event";
    }
}

