/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.distribution.journal.FullMessage;
import org.apache.sling.distribution.journal.impl.shared.PackageBrowser;
import org.apache.sling.distribution.journal.messages.Messages;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Package viewer for content distribution", "felix.webconsole.label=distpackages", "felix.webconsole.title=Distribution Package Viewer"})
public class PackageViewerPlugin
extends AbstractWebConsolePlugin {
    private static final Duration BROWSE_TIMEOUT = Duration.ofMillis(1000L);
    private static final Duration DOWNLOAD_TIMEOUT = Duration.ofMillis(20000L);
    private static final int NOT_FOUND = 404;
    private static final int MAX_NUM_MESSAGES = 100;
    private static final long serialVersionUID = -3113699912185558439L;
    protected static final String LABEL = "distpackages";
    protected static final String TITLE = "Distribution Package Viewer";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    PackageBrowser packageBrowser;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    public String getCategory() {
        return "Sling";
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Optional<Long> offset = this.getOffset(req);
        if (!offset.isPresent()) {
            String startOffsetSt = req.getParameter("startOffset");
            long startOffset = startOffsetSt != null ? Long.parseLong(startOffsetSt) : 0L;
            this.renderPackageList(startOffset, res.getWriter());
        } else {
            this.writePackage(offset.get(), res);
        }
    }

    private void renderPackageList(long startOffset, PrintWriter writer) {
        writer.println("<table class=\"tablesorter nicetable noauto\">");
        writer.println("<tr><th>Id</th><th>Offset</th><th>Type</th><th>Paths</th></tr>");
        List<FullMessage<Messages.PackageMessage>> msgs = this.packageBrowser.getMessages(startOffset, 100L, BROWSE_TIMEOUT);
        msgs.stream().filter(this::notTestMessage).map(this::writeMsg).forEach(writer::println);
        writer.println("</table>");
        if (msgs.size() == 100) {
            FullMessage<Messages.PackageMessage> lastMsg = msgs.get(msgs.size() - 1);
            long nextOffset = lastMsg.getInfo().getOffset() + 1L;
            writer.println(String.format("<p><a href =\"%s?startOffset=%d\">next page</a>", LABEL, nextOffset));
        }
    }

    private String writeMsg(FullMessage<Messages.PackageMessage> msg) {
        return String.format("<tr><td><a href=\"%s/%d\">%s</a></td><td>%d</td><td>%s</td><td>%s</td></tr>", LABEL, msg.getInfo().getOffset(), ((Messages.PackageMessage)msg.getMessage()).getPkgId(), msg.getInfo().getOffset(), ((Messages.PackageMessage)msg.getMessage()).getReqType(), ((Messages.PackageMessage)msg.getMessage()).getPathsList().toString());
    }

    private void writePackage(Long offset, HttpServletResponse res) throws IOException {
        this.log.info("Retrieving package with offset {}", (Object)offset);
        List<FullMessage<Messages.PackageMessage>> msgs = this.packageBrowser.getMessages(offset, 1L, DOWNLOAD_TIMEOUT);
        if (!msgs.isEmpty()) {
            Messages.PackageMessage msg = (Messages.PackageMessage)msgs.iterator().next().getMessage();
            res.setHeader("Content-Type", "application/octet-stream");
            String filename = msg.getPkgId() + ".zip";
            res.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
            this.packageBrowser.writeTo(msg, (OutputStream)res.getOutputStream());
        } else {
            res.setStatus(404);
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return !this.getOffset(request).isPresent();
    }

    private Optional<Long> getOffset(HttpServletRequest req) {
        int startIndex = LABEL.length() + 2;
        if (startIndex <= req.getPathInfo().length()) {
            String offsetSt = req.getPathInfo().substring(startIndex);
            return Optional.of(Long.valueOf(offsetSt));
        }
        return Optional.empty();
    }

    private boolean notTestMessage(FullMessage<Messages.PackageMessage> msg) {
        return ((Messages.PackageMessage)msg.getMessage()).getReqType() != Messages.PackageMessage.ReqType.TEST;
    }
}

