/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.io.Closeable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.impl.shared.ExponentialBackOff;
import org.apache.sling.distribution.journal.impl.shared.JournalAvailableServiceMarker;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventHandler.class}, property={"event.topics=org/apache/sling/distribution/journal/errors"})
public class JournalAvailableChecker
implements EventHandler {
    private static final Duration INITIAL_RETRY_DELAY = Duration.of(500L, ChronoUnit.MILLIS);
    private static final Duration MAX_RETRY_DELAY = Duration.of(5L, ChronoUnit.MINUTES);
    private static final Logger LOG = LoggerFactory.getLogger(JournalAvailableChecker.class);
    private final ExponentialBackOff backoffRetry = new ExponentialBackOff(INITIAL_RETRY_DELAY, MAX_RETRY_DELAY, true, this::run);
    @Reference
    Topics topics;
    @Reference
    MessagingProvider provider;
    @Reference
    DistributionMetricsService metrics;
    private JournalAvailableServiceMarker marker;
    private DistributionMetricsService.GaugeService<Boolean> gauge;

    @Activate
    public void activate(BundleContext context) {
        Objects.requireNonNull(this.provider);
        Objects.requireNonNull(this.topics);
        this.marker = new JournalAvailableServiceMarker(context);
        this.gauge = this.metrics.createGauge("distribution.journal.journal_available", "", this::isAvailable);
        this.marker.register();
        LOG.info("Started Journal availability checker service. Journal is initially assumed available.");
    }

    @Deactivate
    public void deactivate() {
        this.gauge.close();
        this.marker.unRegister();
        IOUtils.closeQuietly((Closeable)this.backoffRetry);
        LOG.info("Stopped Journal availability checker service");
    }

    private void doChecks() {
        this.provider.assertTopic(this.topics.getPackageTopic());
        this.provider.assertTopic(this.topics.getDiscoveryTopic());
        this.provider.assertTopic(this.topics.getStatusTopic());
        this.provider.assertTopic(this.topics.getCommandTopic());
    }

    private void available() {
        LOG.info("Journal is available");
        this.marker.register();
    }

    private void stillUnAvailable(Exception e) {
        String msg = "Journal is still unavailable: " + e.getMessage();
        LOG.warn(msg, (Throwable)e);
        this.marker.unRegister();
    }

    public boolean isAvailable() {
        return this.marker.isRegistered();
    }

    public void run() {
        try {
            LOG.debug("Journal checker is running");
            this.doChecks();
            this.available();
        }
        catch (Exception e) {
            this.stillUnAvailable(e);
            throw e;
        }
    }

    public synchronized void handleEvent(Event event) {
        String type = (String)event.getProperty("type");
        if (this.marker.isRegistered()) {
            LOG.warn("Received exception event {}. Journal is considered unavailable.", (Object)type);
            this.marker.unRegister();
            this.backoffRetry.startChecks();
        } else {
            LOG.info("Received exception event {}. Journal still unavailable.", (Object)type);
        }
    }
}

