/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JMXRegistration
implements Closeable {
    public static final String DOMAIN = "org.apache.sling.distribution";
    private ObjectName name;

    public JMXRegistration(Object bean, String type, String id) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("type", type);
        props.put("id", id);
        try {
            this.name = ObjectName.getInstance(DOMAIN, props);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (!server.isRegistered(this.name)) {
                server.registerMBean(bean, this.name);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.name);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

