/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.queue.impl;

import java.util.Calendar;
import java.util.function.ToIntFunction;
import org.apache.sling.distribution.journal.impl.queue.impl.EntryUtil;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;

public class QueueEntryFactory {
    private final String queueName;
    private final ToIntFunction<DistributionQueueItem> attemptsCallback;

    public QueueEntryFactory(String queueName, ToIntFunction<DistributionQueueItem> attemptsCallback) {
        this.queueName = queueName;
        this.attemptsCallback = attemptsCallback;
    }

    public DistributionQueueEntry create(DistributionQueueItem queueItem) {
        if (queueItem == null) {
            return null;
        }
        String entryId = EntryUtil.entryId(queueItem);
        DistributionQueueItemStatus itemStatus = this.buildQueueItemStatus(queueItem);
        return new DistributionQueueEntry(entryId, queueItem, itemStatus);
    }

    private DistributionQueueItemStatus buildQueueItemStatus(DistributionQueueItem queueItem) {
        int attempts = this.attemptsCallback.applyAsInt(queueItem);
        DistributionQueueItemState state = attempts > 0 ? DistributionQueueItemState.ERROR : DistributionQueueItemState.QUEUED;
        return new DistributionQueueItemStatus(this.itemCalendar(queueItem), state, attempts, this.queueName);
    }

    private Calendar itemCalendar(DistributionQueueItem queueItem) {
        long recordTimestamp = (Long)queueItem.get("recordTimestamp", Long.class);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(recordTimestamp);
        return calendar;
    }
}

