/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.queue.impl;

import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.JournalAvailable;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.queue.OffsetQueue;
import org.apache.sling.distribution.journal.impl.queue.impl.PubQueueCache;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(service={PubQueueCacheService.class, Runnable.class}, property={"scheduler.concurrent:Boolean=false", "scheduler.period:Long=300"})
public class PubQueueCacheService
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PubQueueCacheService.class);
    private static final int CLEANUP_THRESHOLD = 10000;
    @Reference
    private JournalAvailable journalAvailable;
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private Topics topics;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private DistributionMetricsService distributionMetricsService;
    private volatile PubQueueCache cache;

    public PubQueueCacheService() {
    }

    public PubQueueCacheService(MessagingProvider messagingProvider, Topics topics, EventAdmin eventAdmin) {
        this.messagingProvider = messagingProvider;
        this.topics = topics;
        this.eventAdmin = eventAdmin;
    }

    @Activate
    public void activate() {
        this.cache = this.newCache();
        LOG.info("Started Publisher queue cache service");
    }

    @Deactivate
    public void deactivate() {
        if (this.cache != null) {
            this.cache.close();
        }
        LOG.info("Stopped Publisher queue cache service");
    }

    public OffsetQueue<DistributionQueueItem> getOffsetQueue(String pubAgentName, long minOffset) {
        try {
            return this.cache.getOffsetQueue(pubAgentName, minOffset);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void cleanup() {
        if (this.cache != null) {
            int size = this.cache.size();
            if (size > 10000) {
                LOG.info("Cleanup package cache (size={}/{})", (Object)size, (Object)10000);
                this.cache.close();
                this.cache = this.newCache();
            } else {
                LOG.info("No cleanup required for package cache (size={}/{})", (Object)size, (Object)10000);
            }
        }
    }

    private PubQueueCache newCache() {
        return new PubQueueCache(this.messagingProvider, this.eventAdmin, this.distributionMetricsService, this.topics.getPackageTopic());
    }

    @Override
    public void run() {
        LOG.info("Starting package cache cleanup task");
        this.cleanup();
        LOG.info("Stopping package cache cleanup task");
    }
}

