/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.jackrabbit.SimpleReferenceBinary;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.FullMessage;
import org.apache.sling.distribution.journal.JournalAvailable;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.shared.LimitPoller;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.journal.messages.Messages;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PackageBrowser.class})
public class PackageBrowser {
    @Reference
    private JournalAvailable journalAvailable;
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private Topics topics;
    @Reference
    ResourceResolverFactory resolverFactory;

    public List<FullMessage<Messages.PackageMessage>> getMessages(long startOffset, long numMessages, Duration timeout) {
        LimitPoller poller = new LimitPoller(this.messagingProvider, this.topics.getPackageTopic(), startOffset, numMessages);
        return poller.fetch(timeout);
    }

    public void writeTo(Messages.PackageMessage pkgMsg, OutputStream os) throws IOException {
        try (ResourceResolver resolver = this.getServiceResolver("importer");){
            InputStream is = PackageBrowser.pkgStream(resolver, pkgMsg);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (LoginException | DistributionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Nonnull
    public static InputStream pkgStream(ResourceResolver resolver, Messages.PackageMessage pkgMsg) throws DistributionException {
        if (pkgMsg.hasPkgBinary()) {
            return new ByteArrayInputStream(pkgMsg.getPkgBinary().toByteArray());
        }
        String pkgBinRef = pkgMsg.getPkgBinaryRef();
        try {
            Session session = (Session)resolver.adaptTo(Session.class);
            if (session == null) {
                throw new DistributionException("Unable to get Oak session");
            }
            ValueFactory factory = session.getValueFactory();
            Binary binary = factory.createValue((Binary)new SimpleReferenceBinary(pkgBinRef)).getBinary();
            return binary.getStream();
        }
        catch (RepositoryException e) {
            throw new DistributionException(e.getMessage(), (Throwable)e);
        }
    }

    private ResourceResolver getServiceResolver(String subService) throws LoginException {
        return this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", subService));
    }
}

