/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.queue.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.impl.queue.OffsetQueue;
import org.apache.sling.distribution.journal.impl.queue.impl.ClearCallback;
import org.apache.sling.distribution.journal.impl.queue.impl.EntryUtil;
import org.apache.sling.distribution.journal.impl.queue.impl.QueueEntryFactory;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.spi.DistributionQueue;

@ParametersAreNonnullByDefault
public class PubQueue
implements DistributionQueue {
    private final String queueName;
    private final Set<String> capabilities = new HashSet<String>();
    private final OffsetQueue<DistributionQueueItem> offsetQueue;
    private final int retries;
    private final DistributionQueueItem headItem;
    private final ClearCallback clearCallback;
    private final QueueEntryFactory entryFactory;

    public PubQueue(String queueName, OffsetQueue<DistributionQueueItem> offsetQueue, int retries, @Nullable ClearCallback clearCallback) {
        this.queueName = Objects.requireNonNull(queueName);
        this.offsetQueue = Objects.requireNonNull(offsetQueue);
        this.retries = retries;
        this.clearCallback = clearCallback;
        if (clearCallback != null) {
            this.capabilities.add("clearable");
            this.capabilities.add("removable");
        }
        this.entryFactory = new QueueEntryFactory(queueName, this::attempts);
        this.headItem = offsetQueue.getHeadItem();
    }

    @Nonnull
    public String getName() {
        return this.queueName;
    }

    public DistributionQueueEntry add(DistributionQueueItem queueItem) {
        throw new UnsupportedOperationException("Unsupported add operation");
    }

    public DistributionQueueEntry getHead() {
        DistributionQueueItem headItem = this.offsetQueue.getHeadItem();
        return this.entryFactory.create(headItem);
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> getEntries(int skip, int limit) {
        ArrayList<DistributionQueueEntry> entries = new ArrayList<DistributionQueueEntry>();
        for (DistributionQueueItem queueItem : this.offsetQueue.getHeadItems(skip, limit)) {
            entries.add(this.entryFactory.create(queueItem));
        }
        return entries;
    }

    public DistributionQueueEntry getEntry(String entryId) {
        DistributionQueueItem queueItem = this.offsetQueue.getItem(EntryUtil.entryOffset(entryId));
        return this.entryFactory.create(queueItem);
    }

    public DistributionQueueEntry remove(String entryId) {
        DistributionQueueEntry headEntry = this.getHead();
        if (headEntry != null) {
            if (headEntry.getId().equals(entryId)) {
                this.clear(headEntry);
            } else {
                throw new UnsupportedOperationException("Unsupported random clear operation");
            }
        }
        return headEntry;
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> remove(Set<String> entryIds) {
        Optional tailEntryId = entryIds.stream().max((e1, e2) -> Long.compare(EntryUtil.entryOffset(e1), EntryUtil.entryOffset(e2)));
        return tailEntryId.isPresent() ? this.clear((String)tailEntryId.get()) : Collections.emptyList();
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> clear(int limit) {
        Iterable<DistributionQueueEntry> removed = this.getEntries(0, limit);
        StreamSupport.stream(removed.spliterator(), false).reduce((e1, e2) -> e2).ifPresent(this::clear);
        return removed;
    }

    @Nonnull
    public DistributionQueueStatus getStatus() {
        DistributionQueueState queueState;
        int itemsCount;
        DistributionQueueEntry headEntry = this.getHead();
        if (headEntry != null) {
            itemsCount = this.offsetQueue.getSize();
            DistributionQueueItemState itemState = headEntry.getStatus().getItemState();
            queueState = itemState == DistributionQueueItemState.QUEUED ? DistributionQueueState.RUNNING : DistributionQueueState.BLOCKED;
        } else {
            itemsCount = 0;
            queueState = DistributionQueueState.IDLE;
        }
        return new DistributionQueueStatus(itemsCount, queueState);
    }

    @Nonnull
    public DistributionQueueType getType() {
        return DistributionQueueType.ORDERED;
    }

    public boolean hasCapability(String capability) {
        return this.capabilities.contains(capability);
    }

    private Integer attempts(DistributionQueueItem queueItem) {
        return queueItem.equals((Object)this.headItem) ? this.retries : 0;
    }

    private Iterable<DistributionQueueEntry> clear(String tailEntryId) {
        ArrayList<DistributionQueueEntry> removed = new ArrayList<DistributionQueueEntry>();
        for (DistributionQueueEntry entry : this.getEntries(0, -1)) {
            removed.add(entry);
            if (!tailEntryId.equals(entry.getId())) continue;
            this.clear(entry);
            return removed;
        }
        return Collections.emptyList();
    }

    private void clear(DistributionQueueEntry tailEntry) {
        if (this.clearCallback == null) {
            throw new UnsupportedOperationException();
        }
        this.clearCallback.clear(EntryUtil.entryOffset(tailEntry.getId()));
    }
}

