/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PackageQueuedNotifier.class, EventHandler.class}, property={"event.topics=org/apache/sling/distribution/agent/package/queued"})
public class PackageQueuedNotifier
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PackageQueuedNotifier.class);
    private final Map<String, CompletableFuture<Void>> receiveCallbacks = new ConcurrentHashMap<String, CompletableFuture<Void>>();

    @Deactivate
    public void deactivate() {
        this.receiveCallbacks.forEach((packageId, callback) -> {
            LOG.debug("Cancel wait condition for package {}", packageId);
            callback.cancel(true);
        });
        LOG.info("Package queue notifier service stopped");
    }

    public void handleEvent(Event event) {
        String packageId = (String)event.getProperty("distribution.package.id");
        LOG.debug("Handling event for packageId {}", (Object)packageId);
        CompletableFuture<Void> callback = this.receiveCallbacks.remove(packageId);
        if (callback != null) {
            callback.complete(null);
        }
    }

    public CompletableFuture<Void> registerWait(String packageId) {
        LOG.debug("Registering wait condition for packageId {}", (Object)packageId);
        CompletableFuture<Void> packageReceived = new CompletableFuture<Void>();
        this.receiveCallbacks.put(packageId, packageReceived);
        return packageReceived;
    }

    public void unRegisterWait(String packageId) {
        LOG.debug("Un-registering wait condition for packageId {}", (Object)packageId);
        this.receiveCallbacks.remove(packageId);
    }
}

