/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.io.Closeable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.JournalAvailable;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.impl.shared.ExponentialBackOff;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/apache/sling/distribution/journal/errors"})
public class JournalAvailableChecker
implements JournalAvailable,
EventHandler {
    private static final Duration INITIAL_RETRY_DELAY = Duration.of(1L, ChronoUnit.SECONDS);
    private static final Duration MAX_RETRY_DELAY = Duration.of(5L, ChronoUnit.MINUTES);
    public static final int MIN_ERRORS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(JournalAvailableChecker.class);
    private final ExponentialBackOff backoffRetry;
    private final AtomicInteger numErrors = new AtomicInteger();
    @Reference
    Topics topics;
    @Reference
    MessagingProvider provider;
    @Reference
    DistributionMetricsService metrics;
    private BundleContext context;
    private volatile ServiceRegistration<JournalAvailable> reg;
    private DistributionMetricsService.GaugeService<Boolean> gauge;

    public JournalAvailableChecker() {
        this.backoffRetry = new ExponentialBackOff(INITIAL_RETRY_DELAY, MAX_RETRY_DELAY, true, this::run);
    }

    @Activate
    public void activate(BundleContext context) {
        Objects.requireNonNull(this.provider);
        Objects.requireNonNull(this.topics);
        this.context = context;
        this.backoffRetry.startChecks();
        this.gauge = this.metrics.createGauge("distribution.journal.journal_available", "", this::isAvailable);
        LOG.info("Started Journal availability checker service");
    }

    @Deactivate
    public void deactivate() {
        this.gauge.close();
        this.unRegister();
        IOUtils.closeQuietly((Closeable)this.backoffRetry);
        LOG.info("Stopped Journal availability checker service");
    }

    private void doChecks() {
        this.provider.assertTopic(this.topics.getPackageTopic());
        this.provider.assertTopic(this.topics.getDiscoveryTopic());
        this.provider.assertTopic(this.topics.getStatusTopic());
        this.provider.assertTopic(this.topics.getCommandTopic());
    }

    private void available() {
        LOG.info("Journal is available");
        if (this.reg == null) {
            this.reg = this.context.registerService(JournalAvailable.class, (Object)this, null);
        }
    }

    private void stillUnAvailable(Exception e) {
        String msg = "Journal is still unavailable: " + e.getMessage();
        if (LOG.isDebugEnabled()) {
            LOG.warn(msg, (Throwable)e);
        } else {
            LOG.warn(msg);
        }
        this.unRegister();
    }

    public boolean isAvailable() {
        return this.reg != null;
    }

    public void run() {
        try {
            LOG.debug("Journal checker is running");
            this.doChecks();
            this.available();
        }
        catch (Exception e) {
            this.stillUnAvailable(e);
            throw e;
        }
    }

    private void unRegister() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    public synchronized void handleEvent(Event event) {
        String type = (String)event.getProperty("type");
        int curNumErrors = this.numErrors.incrementAndGet();
        if (curNumErrors >= 2) {
            LOG.warn("Received exception event {}. Journal is considered unavailable.", (Object)type);
            this.unRegister();
            this.numErrors.set(0);
            this.backoffRetry.startChecks();
        } else {
            LOG.info("Received exception event {}. {} of {} errors occurred.", new Object[]{type, curNumErrors, 2});
        }
    }
}

