/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.io.Closeable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.Gauge;
import org.apache.sling.commons.metrics.Histogram;
import org.apache.sling.commons.metrics.Meter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DistributionMetricsService.class})
public class DistributionMetricsService {
    public static final String BASE_COMPONENT = "distribution.journal";
    private static final String PUB_COMPONENT = "distribution.journal.publisher";
    public static final String SUB_COMPONENT = "distribution.journal.subscriber";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private MetricsService metricsService;
    private Counter cleanupPackageRemovedCount;
    private Timer cleanupPackageDuration;
    private Histogram importedPackageSize;
    private Histogram exportedPackageSize;
    private Meter acceptedRequests;
    private Meter droppedRequests;
    private Counter itemsBufferSize;
    private Timer removedPackageDuration;
    private Timer removedFailedPackageDuration;
    private Timer importedPackageDuration;
    private Meter failedPackageImports;
    private Timer sendStoredStatusDuration;
    private Timer processQueueItemDuration;
    private Timer packageDistributedDuration;
    private Timer buildPackageDuration;
    private Timer enqueuePackageDuration;
    private Counter queueCacheFetchCount;
    private BundleContext context;

    @Activate
    public void activate(BundleContext context) {
        this.context = context;
        this.cleanupPackageRemovedCount = this.getCounter(this.getMetricName(PUB_COMPONENT, "cleanup_package_removed_count"));
        this.cleanupPackageDuration = this.getTimer(this.getMetricName(PUB_COMPONENT, "cleanup_package_duration"));
        this.exportedPackageSize = this.getHistogram(this.getMetricName(PUB_COMPONENT, "exported_package_size"));
        this.acceptedRequests = this.getMeter(this.getMetricName(PUB_COMPONENT, "accepted_requests"));
        this.droppedRequests = this.getMeter(this.getMetricName(PUB_COMPONENT, "dropped_requests"));
        this.buildPackageDuration = this.getTimer(this.getMetricName(PUB_COMPONENT, "build_package_duration"));
        this.enqueuePackageDuration = this.getTimer(this.getMetricName(PUB_COMPONENT, "enqueue_package_duration"));
        this.queueCacheFetchCount = this.getCounter(this.getMetricName(PUB_COMPONENT, "queue_cache_fetch_count"));
        this.importedPackageSize = this.getHistogram(this.getMetricName(SUB_COMPONENT, "imported_package_size"));
        this.itemsBufferSize = this.getCounter(this.getMetricName(SUB_COMPONENT, "items_buffer_size"));
        this.importedPackageDuration = this.getTimer(this.getMetricName(SUB_COMPONENT, "imported_package_duration"));
        this.removedPackageDuration = this.getTimer(this.getMetricName(SUB_COMPONENT, "removed_package_duration"));
        this.removedFailedPackageDuration = this.getTimer(this.getMetricName(SUB_COMPONENT, "removed_failed_package_duration"));
        this.failedPackageImports = this.getMeter(this.getMetricName(SUB_COMPONENT, "failed_package_imports"));
        this.sendStoredStatusDuration = this.getTimer(this.getMetricName(SUB_COMPONENT, "send_stored_status_duration"));
        this.processQueueItemDuration = this.getTimer(this.getMetricName(SUB_COMPONENT, "process_queue_item_duration"));
        this.packageDistributedDuration = this.getTimer(this.getMetricName(SUB_COMPONENT, "request_distributed_duration"));
    }

    public static void timed(Timer metric, Runnable code) throws Exception {
        try (Timer.Context ignored = metric.time();){
            code.run();
        }
    }

    public static <T> T timed(Timer metric, Callable<T> code) throws Exception {
        try (Timer.Context ignored = metric.time();){
            T t = code.call();
            return t;
        }
    }

    public Counter getCleanupPackageRemovedCount() {
        return this.cleanupPackageRemovedCount;
    }

    public Timer getCleanupPackageDuration() {
        return this.cleanupPackageDuration;
    }

    public Histogram getImportedPackageSize() {
        return this.importedPackageSize;
    }

    public Histogram getExportedPackageSize() {
        return this.exportedPackageSize;
    }

    public Meter getAcceptedRequests() {
        return this.acceptedRequests;
    }

    public Meter getDroppedRequests() {
        return this.droppedRequests;
    }

    public Counter getItemsBufferSize() {
        return this.itemsBufferSize;
    }

    public Timer getImportedPackageDuration() {
        return this.importedPackageDuration;
    }

    public Timer getRemovedPackageDuration() {
        return this.removedPackageDuration;
    }

    public Timer getRemovedFailedPackageDuration() {
        return this.removedFailedPackageDuration;
    }

    public Meter getFailedPackageImports() {
        return this.failedPackageImports;
    }

    public Timer getSendStoredStatusDuration() {
        return this.sendStoredStatusDuration;
    }

    public Timer getProcessQueueItemDuration() {
        return this.processQueueItemDuration;
    }

    public Timer getPackageDistributedDuration() {
        return this.packageDistributedDuration;
    }

    public Timer getBuildPackageDuration() {
        return this.buildPackageDuration;
    }

    public Timer getEnqueuePackageDuration() {
        return this.enqueuePackageDuration;
    }

    public Counter getQueueCacheFetchCount() {
        return this.queueCacheFetchCount;
    }

    public <T> GaugeService<T> createGauge(String name, String description, Supplier<T> supplier) {
        return new GaugeService(name, description, supplier);
    }

    private String getMetricName(String component, String name) {
        return String.format("%s.%s", component, name);
    }

    private Counter getCounter(String metricName) {
        return this.metricsService.counter(metricName);
    }

    private Timer getTimer(String metricName) {
        return this.metricsService.timer(metricName);
    }

    private Histogram getHistogram(String metricName) {
        return this.metricsService.histogram(metricName);
    }

    private Meter getMeter(String metricName) {
        return this.metricsService.meter(metricName);
    }

    public class GaugeService<T>
    implements Gauge<T>,
    Closeable {
        private ServiceRegistration<Gauge> reg;
        private Supplier<T> supplier;

        private GaugeService(String name, String description, Supplier<T> supplier) {
            this.supplier = supplier;
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", description);
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("name", name);
            this.reg = DistributionMetricsService.this.context.registerService(Gauge.class, (Object)this, props);
        }

        public T getValue() {
            return this.supplier.get();
        }

        @Override
        public void close() {
            try {
                this.reg.unregister();
            }
            catch (Exception e) {
                DistributionMetricsService.this.log.warn("Error unregistering service", (Throwable)e);
            }
        }
    }
}

