/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ParametersAreNonnullByDefault
@Immutable
public class State {
    private final long timestamp;
    private final long offset;
    private final int retries;
    private final String pubAgentName;
    private final String subAgentId;
    private final boolean editable;
    private final int maxRetries;

    public State(String pubAgentName, String subAgentId, long timestamp, long offset, int retries, int maxRetries, boolean editable) {
        this.pubAgentName = pubAgentName;
        this.subAgentId = subAgentId;
        this.timestamp = timestamp;
        this.offset = offset;
        this.retries = retries;
        this.maxRetries = maxRetries;
        this.editable = editable;
    }

    public String getPubAgentName() {
        return this.pubAgentName;
    }

    public String getSubAgentId() {
        return this.subAgentId;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return this.offset == state.offset && this.retries == state.retries && this.maxRetries == state.maxRetries && this.editable == state.editable && Objects.equals(this.pubAgentName, state.pubAgentName) && Objects.equals(this.subAgentId, state.subAgentId);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.retries, this.maxRetries, this.editable, this.pubAgentName, this.subAgentId);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("timestamp", this.timestamp).append("offset", this.offset).append("retries", this.retries).append("maxRetries", this.maxRetries).append("editable", this.editable).append("pubAgentName", (Object)this.pubAgentName).append("subAgentId", (Object)this.subAgentId).toString();
    }
}

