/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.io.Closeable;
import java.util.UUID;
import org.apache.sling.distribution.journal.MessageSender;
import org.apache.sling.distribution.journal.MessagingException;
import org.apache.sling.distribution.journal.RunnableUtil;
import org.apache.sling.distribution.journal.messages.PackageMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueCacheSeeder
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(QueueCacheSeeder.class);
    private static final long CACHE_SEEDING_DELAY_MS = 10000L;
    private static final int MAX_CACHE_SEEDING_DELAY_MS = 900000;
    private volatile boolean closed;
    private MessageSender<PackageMessage> sender;
    private Thread seedingThread;

    public QueueCacheSeeder(MessageSender<PackageMessage> sender) {
        this.sender = sender;
    }

    public void startSeeding() {
        this.seedingThread = RunnableUtil.startBackgroundThread(this::sendSeedingMessages, (String)"Seeder thread");
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.seedingThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSeedingMessages() {
        LOG.info("Start message seeder");
        int count = 1;
        long cacheSeedingDelay = 10000L;
        try {
            while (!this.closed) {
                LOG.info("Send seeding message {} then wait {} ms", (Object)count, (Object)cacheSeedingDelay);
                this.sendSeedingMessage();
                this.delay(cacheSeedingDelay);
                cacheSeedingDelay = Math.min(cacheSeedingDelay * 2L, 900000L);
                ++count;
            }
        }
        finally {
            LOG.info("Stop message seeder");
        }
    }

    private void sendSeedingMessage() {
        try {
            PackageMessage pkgMsg = this.createTestMessage();
            this.sender.send((Object)pkgMsg);
        }
        catch (MessagingException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void delay(long sleepMs) {
        long sleepCycles = sleepMs / 100L;
        int curCycle = 0;
        while ((long)curCycle < sleepCycles) {
            if (this.closed) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++curCycle;
        }
    }

    protected PackageMessage createTestMessage() {
        String pkgId = UUID.randomUUID().toString();
        return PackageMessage.builder().pubSlingId("seeder").pkgId(pkgId).pkgType("seeder").reqType(PackageMessage.ReqType.TEST).build();
    }
}

