/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PackageRetries {
    private final Map<String, Integer> pubAgentNameToRetries = new ConcurrentHashMap<String, Integer>();

    public void increase(String pubAgentName) {
        this.pubAgentNameToRetries.merge(pubAgentName, 1, Integer::sum);
    }

    public void clear(String pubAgentName) {
        this.pubAgentNameToRetries.remove(pubAgentName);
    }

    public int get(String pubAgentName) {
        return this.pubAgentNameToRetries.getOrDefault(pubAgentName, 0);
    }

    public int getSum() {
        return this.pubAgentNameToRetries.values().stream().mapToInt(Integer::intValue).sum();
    }
}

