/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.messages.PackageMessage;
import org.osgi.service.event.Event;

@ParametersAreNonnullByDefault
class ImportedEvent {
    public static final String PACKAGE_ID = "distribution.package.id";
    private static final String KIND_IMPORTER = "importer";
    private PackageMessage pkgMsg;
    private String agentName;

    ImportedEvent(PackageMessage pkgMsg, String agentName) {
        this.pkgMsg = pkgMsg;
        this.agentName = agentName;
    }

    Event toEvent() {
        String[] paths = this.pkgMsg.getPaths().toArray(new String[0]);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("distribution.component.kind", KIND_IMPORTER);
        props.put("distribution.component.name", this.agentName);
        props.put("distribution.type", this.pkgMsg.getReqType().name());
        props.put("distribution.paths", paths);
        props.put(PACKAGE_ID, this.pkgMsg.getPkgId());
        return new Event("org/apache/sling/distribution/importer/package/imported", props);
    }
}

