/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import com.google.protobuf.GeneratedMessage;
import java.io.Closeable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.MessageSender;
import org.apache.sling.distribution.journal.impl.queue.impl.PackageRetries;
import org.apache.sling.distribution.journal.impl.subscriber.LocalStore;
import org.apache.sling.distribution.journal.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class Announcer
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Announcer.class);
    private final String topicName;
    private final LocalStore offsetStore;
    private final MessageSender<Messages.DiscoveryMessage> sender;
    private final String subSlingId;
    private final String subAgentName;
    private final Set<String> pubAgentNames;
    private final PackageRetries packageRetries;
    private final boolean editable;
    private final int maxRetries;
    private final ScheduledExecutorService executor;

    public Announcer(String subSlingId, String subAgentName, String topicName, Set<String> pubAgentNames, MessageSender<Messages.DiscoveryMessage> disSender, LocalStore offsetStore, PackageRetries packageRetries, int maxRetries, boolean editable, int announceDelay) {
        this.subSlingId = Objects.requireNonNull(subSlingId);
        this.subAgentName = Objects.requireNonNull(subAgentName);
        this.topicName = Objects.requireNonNull(topicName);
        this.pubAgentNames = Objects.requireNonNull(pubAgentNames);
        this.sender = Objects.requireNonNull(disSender);
        this.offsetStore = Objects.requireNonNull(offsetStore);
        this.packageRetries = Objects.requireNonNull(packageRetries);
        this.maxRetries = maxRetries;
        this.editable = editable;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(this, 0L, announceDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        LOG.debug("Sending discovery message for agent {}", (Object)this.subAgentName);
        try {
            long offset = this.offsetStore.load("offset", -1L);
            Messages.SubscriberConfiguration subscriberConfiguration = Messages.SubscriberConfiguration.newBuilder().setEditable(this.editable).setMaxRetries(this.maxRetries).build();
            Messages.DiscoveryMessage.Builder disMsgBuilder = Messages.DiscoveryMessage.newBuilder().setSubSlingId(this.subSlingId).setSubAgentName(this.subAgentName).setSubscriberConfiguration(subscriberConfiguration);
            for (String pubAgentName : this.pubAgentNames) {
                int retries = this.packageRetries.get(pubAgentName);
                disMsgBuilder.addSubscriberState(this.createOffset(pubAgentName, offset, retries));
            }
            this.sender.send(this.topicName, (GeneratedMessage)disMsgBuilder.build());
        }
        catch (Throwable e) {
            String msg = String.format("Failed to send discovery message for agent %s, %s", this.subAgentName, e.getMessage());
            LOG.info(msg, e);
        }
    }

    private Messages.SubscriberState createOffset(String pubAgentName, long offset, int retries) {
        return Messages.SubscriberState.newBuilder().setPubAgentName(pubAgentName).setRetries(retries).setOffset(offset).build();
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

