/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.JournalAvailable;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(service={Runnable.class}, immediate=true, property={"scheduler.immediate:Boolean=true", "scheduler.concurrent:Boolean=false", "scheduler.period:Long=90"})
public class JournalAvailableChecker
implements JournalAvailable,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(JournalAvailableChecker.class);
    @Reference
    Topics topics;
    @Reference
    MessagingProvider provider;
    @Reference
    DistributionMetricsService metrics;
    private BundleContext context;
    private volatile ServiceRegistration<JournalAvailable> reg;
    private DistributionMetricsService.GaugeService<Boolean> gauge;

    @Activate
    public void activate(BundleContext context) {
        Objects.requireNonNull(this.provider);
        Objects.requireNonNull(this.topics);
        this.context = context;
        this.gauge = this.metrics.createGauge("distribution.journal.journal_available", "", this::isAvailable);
        LOG.info("Started Journal availability checker service");
    }

    @Deactivate
    public void deactivate() {
        this.gauge.close();
        this.unRegister();
        LOG.info("Stopped Journal availability checker service");
    }

    private void doChecks() {
        this.provider.assertTopic(this.topics.getPackageTopic());
        this.provider.assertTopic(this.topics.getDiscoveryTopic());
        this.provider.assertTopic(this.topics.getStatusTopic());
        this.provider.assertTopic(this.topics.getCommandTopic());
    }

    private void available() {
        if (this.reg == null) {
            LOG.info("Journal is available");
            this.reg = this.context.registerService(JournalAvailable.class, (Object)this, null);
        }
    }

    private void unAvailable(Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.warn("Journal is unavailable " + e.getMessage(), (Throwable)e);
        } else {
            LOG.warn("Journal is unavailable " + e.getMessage());
        }
        this.unRegister();
    }

    public boolean isAvailable() {
        return this.reg != null;
    }

    @Override
    public void run() {
        try {
            LOG.debug("Journal checker is running");
            this.doChecks();
            this.available();
        }
        catch (Exception e) {
            this.unAvailable(e);
        }
    }

    private void unRegister() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }
}

