/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.impl.publisher.PackageRepo;
import org.apache.sling.distribution.journal.messages.Messages;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(service={PackageMessageFactory.class})
public class PackageMessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PackageMessageFactory.class);
    private static final long MAX_INLINE_PKG_BINARY_SIZE = 819200L;
    @Reference
    private SlingSettingsService slingSettings;
    @Reference
    private PackageRepo packageRepo;
    private String pubSlingId;

    public PackageMessageFactory() {
    }

    public PackageMessageFactory(String pubSlingId) {
        this.pubSlingId = pubSlingId;
    }

    @Activate
    public void activate() {
        this.pubSlingId = this.slingSettings.getSlingId();
        LOG.info("Started package message factory for pubSlingId {}", (Object)this.pubSlingId);
    }

    @Deactivate
    public void deactivate() {
        LOG.info("Stopped package message factory for pubSlingId {}", (Object)this.pubSlingId);
    }

    public Messages.PackageMessage create(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, String pubAgentName, DistributionRequest request) throws DistributionException {
        switch (request.getRequestType()) {
            case ADD: {
                return this.createAdd(packageBuilder, resourceResolver, pubAgentName, request);
            }
            case DELETE: {
                return this.createDelete(packageBuilder, resourceResolver, request, pubAgentName);
            }
            case TEST: {
                return this.createTest(packageBuilder, resourceResolver, pubAgentName);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported request type %s", request.getRequestType()));
    }

    @Nonnull
    private Messages.PackageMessage createAdd(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, String pubAgentName, DistributionRequest request) throws DistributionException {
        DistributionPackage disPkg = Objects.requireNonNull(packageBuilder.createPackage(resourceResolver, request));
        byte[] pkgBinary = this.pkgBinary(disPkg);
        long pkgLength = pkgBinary.length;
        DistributionPackageInfo pkgInfo = disPkg.getInfo();
        List<String> paths = Arrays.asList(pkgInfo.getPaths());
        List<Object> deepPaths = Arrays.asList((Object[])pkgInfo.get("request.deepPaths", String[].class));
        String pkgId = disPkg.getId();
        Messages.PackageMessage.Builder pkgBuilder = Messages.PackageMessage.newBuilder().setPubSlingId(this.pubSlingId).setPkgId(pkgId).setPubAgentName(pubAgentName).addAllPaths(paths).setReqType(Messages.PackageMessage.ReqType.ADD).addAllDeepPaths(deepPaths).setPkgLength(pkgLength).setUserId(resourceResolver.getUserID()).setPkgType(packageBuilder.getType());
        if (pkgLength > 819200L) {
            LOG.info(String.format("Package %s too large (%sB) to be sent inline", disPkg.getId(), pkgLength));
            String pkgBinRef = this.packageRepo.store(resourceResolver, disPkg);
            pkgBuilder.setPkgBinaryRef(pkgBinRef);
        } else {
            pkgBuilder.setPkgBinary(ByteString.copyFrom((byte[])pkgBinary));
        }
        Messages.PackageMessage pipePackage = pkgBuilder.build();
        disPkg.delete();
        return pipePackage;
    }

    @Nonnull
    private Messages.PackageMessage createDelete(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, DistributionRequest request, String pubAgentName) {
        String pkgId = UUID.randomUUID().toString();
        return Messages.PackageMessage.newBuilder().setPubSlingId(this.pubSlingId).setPkgId(pkgId).setPubAgentName(pubAgentName).addAllPaths(Arrays.asList(request.getPaths())).setReqType(Messages.PackageMessage.ReqType.DELETE).setPkgType(packageBuilder.getType()).setUserId(resourceResolver.getUserID()).build();
    }

    @Nonnull
    public Messages.PackageMessage createTest(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, String pubAgentName) {
        String pkgId = UUID.randomUUID().toString();
        return Messages.PackageMessage.newBuilder().setPubSlingId(this.pubSlingId).setPubAgentName(pubAgentName).setPkgId(pkgId).setReqType(Messages.PackageMessage.ReqType.TEST).setPkgType(packageBuilder.getType()).setUserId(resourceResolver.getUserID()).build();
    }

    @Nonnull
    private byte[] pkgBinary(DistributionPackage pkg) {
        try {
            return IOUtils.toByteArray((InputStream)pkg.createInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

