/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.Closeable;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.StateType;
import org.apache.felix.systemready.SystemReadyCheck;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SubscriberIdle
implements SystemReadyCheck,
Closeable {
    public static final int DEFAULT_IDLE_TIME_MILLIS = 10000;
    private final int idleMillis;
    private final AtomicBoolean isReady;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> schedule;
    private final ServiceRegistration<SystemReadyCheck> reg;

    public SubscriberIdle(BundleContext context, int idleMillis, AtomicBoolean readyHolder) {
        this.idleMillis = idleMillis;
        this.isReady = readyHolder;
        this.executor = Executors.newScheduledThreadPool(1);
        this.idle();
        this.reg = context.registerService(SystemReadyCheck.class, (Object)this, new Hashtable());
    }

    public String getName() {
        return "DistributionSubscriber idle";
    }

    public CheckStatus getStatus() {
        CheckStatus.State state = this.isReady.get() ? CheckStatus.State.GREEN : CheckStatus.State.RED;
        return new CheckStatus(this.getName(), StateType.READY, state, "DistributionSubscriber idle");
    }

    public synchronized void busy() {
        this.cancelSchedule();
    }

    public synchronized void idle() {
        if (!this.isReady.get()) {
            this.cancelSchedule();
            this.schedule = this.executor.schedule(this::ready, (long)this.idleMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelSchedule() {
        if (this.schedule != null) {
            this.schedule.cancel(false);
        }
    }

    private void ready() {
        this.isReady.set(true);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        if (this.reg != null) {
            this.reg.unregister();
        }
    }
}

