/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.impl.subscriber.PackageHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPackageExtractor {
    private static final String PACKAGE_BASE_PATH = "/etc/packages/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Packaging packageService;
    private final PackageHandling packageHandling;

    public ContentPackageExtractor(Packaging packageService, PackageHandling packageHandling) {
        this.packageService = packageService;
        this.packageHandling = packageHandling;
    }

    public void handle(ResourceResolver resourceResolver, List<String> paths) throws DistributionException {
        Objects.requireNonNull(resourceResolver, "Must provide resourceResolver");
        if (this.packageHandling == PackageHandling.Off) {
            return;
        }
        this.log.debug("Scanning imported nodes for packages to install.");
        for (String path : paths) {
            try {
                Resource resource = resourceResolver.getResource(path);
                if (resource != null) {
                    Node node = (Node)resource.adaptTo(Node.class);
                    if (!this.isContentPackage(path, node)) continue;
                    this.installPackage(path, node);
                    continue;
                }
                this.log.warn("Imported node {} does not exist. Skipping.", (Object)path);
            }
            catch (Exception e) {
                throw new DistributionException("Error trying to extract package at path " + path, (Throwable)e);
            }
        }
    }

    private boolean isContentPackage(String path, Node node) throws RepositoryException {
        return path.startsWith(PACKAGE_BASE_PATH) && node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file");
    }

    private void installPackage(String path, Node node) throws RepositoryException, PackageException, IOException {
        this.log.info("Content package received at {}. Starting import.\n", (Object)path);
        Session session = node.getSession();
        JcrPackageManager packMgr = this.packageService.getPackageManager(session);
        try (JcrPackage pack = packMgr.open(node);){
            if (pack != null) {
                this.installPackage(pack);
            }
        }
    }

    private void installPackage(JcrPackage pack) throws RepositoryException, PackageException, IOException {
        ImportOptions opts = new ImportOptions();
        if (this.packageHandling == PackageHandling.Extract) {
            pack.extract(opts);
        } else {
            pack.install(opts);
        }
    }
}

