/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.queue.impl;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.journal.JournalAvailable;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.queue.OffsetQueue;
import org.apache.sling.distribution.journal.impl.queue.impl.PubQueueCache;
import org.apache.sling.distribution.journal.impl.queue.impl.QueueCacheSeeder;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.impl.shared.PublisherConfigurationAvailable;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.journal.impl.subscriber.LocalStore;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(immediate=true, service={PubQueueCacheService.class})
public class PubQueueCacheService {
    private static final Logger LOG = LoggerFactory.getLogger(PubQueueCacheService.class);
    private static final int CLEANUP_THRESHOLD = 10000;
    @Reference
    private JournalAvailable journalAvailable;
    @Reference
    private PublisherConfigurationAvailable publisherConfigurationAvailable;
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private Topics topics;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private DistributionMetricsService distributionMetricsService;
    @Reference
    private SlingSettingsService slingSettings;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private volatile PubQueueCache cache;
    private String pubSlingId;

    public PubQueueCacheService() {
    }

    public PubQueueCacheService(MessagingProvider messagingProvider, Topics topics, EventAdmin eventAdmin, SlingSettingsService slingSettingsService, ResourceResolverFactory resolverFactory, String pubSlingId) {
        this.messagingProvider = messagingProvider;
        this.topics = topics;
        this.eventAdmin = eventAdmin;
        this.slingSettings = slingSettingsService;
        this.resolverFactory = resolverFactory;
        this.pubSlingId = pubSlingId;
    }

    @Activate
    public void activate() {
        this.pubSlingId = this.slingSettings.getSlingId();
        this.cache = this.newCache();
        LOG.info("Started Publisher queue cache service");
    }

    @Deactivate
    public void deactivate() {
        PubQueueCache queueCache = this.cache;
        if (queueCache != null) {
            queueCache.close();
        }
        LOG.info("Stopped Publisher queue cache service");
    }

    @Nonnull
    public OffsetQueue<DistributionQueueItem> getOffsetQueue(String pubAgentName, long minOffset) {
        try {
            return this.cache.getOffsetQueue(pubAgentName, minOffset);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
        PubQueueCache queueCache = this.cache;
        if (queueCache != null) {
            int size = queueCache.size();
            if (size > 10000) {
                LOG.info("Cleanup package cache (size={}/{})", (Object)size, (Object)10000);
                queueCache.close();
                this.cache = this.newCache();
            } else {
                LOG.info("No cleanup required for package cache (size={}/{})", (Object)size, (Object)10000);
            }
        }
    }

    public void storeSeed() {
        PubQueueCache queueCache = this.cache;
        if (queueCache != null) {
            queueCache.storeSeed();
        }
    }

    private PubQueueCache newCache() {
        LocalStore seedStore = new LocalStore(this.resolverFactory, "seeds", this.pubSlingId);
        String topic = this.topics.getPackageTopic();
        QueueCacheSeeder seeder = new QueueCacheSeeder(this.messagingProvider, topic);
        return new PubQueueCache(this.messagingProvider, this.eventAdmin, this.distributionMetricsService, topic, seedStore, seeder);
    }
}

