/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.distribution.journal.impl.publisher.State;

@ParametersAreNonnullByDefault
@Immutable
public class TopologyView {
    private final Set<State> states;

    public TopologyView() {
        this(Collections.emptySet());
    }

    public TopologyView(Set<State> newStates) {
        this.states = Collections.unmodifiableSet(newStates);
    }

    public Set<String> getSubscribedAgentIds() {
        return this.states.stream().map(State::getSubAgentId).collect(Collectors.toSet());
    }

    public Set<String> getSubscribedAgentIds(String pubAgentName) {
        return this.states.stream().filter(state -> state.getPubAgentName().equals(pubAgentName)).map(State::getSubAgentId).collect(Collectors.toSet());
    }

    public Set<State> getSubscribedAgents(String pubAgentName) {
        return this.states.stream().filter(state -> state.getPubAgentName().equals(pubAgentName)).collect(Collectors.toSet());
    }

    public Set<State> getSubscriberAgentStates(String subAgentId) {
        return this.states.stream().filter(state -> state.getSubAgentId().equals(subAgentId)).collect(Collectors.toSet());
    }

    @CheckForNull
    public State getState(String subAgentId, String pubAgentName) {
        return this.states.stream().filter(state -> state.getSubAgentId().equals(subAgentId)).filter(state -> state.getPubAgentName().equals(pubAgentName)).findFirst().orElse(null);
    }

    public Map<String, Long> getMinOffsetByPubAgentName() {
        return this.states.stream().collect(Collectors.groupingBy(State::getPubAgentName, Collectors.reducing(Long.MAX_VALUE, State::getOffset, Long::min)));
    }

    public Stream<Long> offsets() {
        return this.states.stream().map(State::getOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyView that = (TopologyView)o;
        return Objects.equals(this.states, that.states);
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("states", this.states).toString();
    }
}

