/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.jcr.Binary;
import javax.jcr.Node;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.impl.publisher.PackageCleaner;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(service={PackageRepo.class})
public class PackageRepo {
    private static final String SLING_FOLDER = "sling:Folder";
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private ServiceUserMapped mapped;
    @Reference
    private DistributionMetricsService distributionMetricsService;
    private static final Logger LOG = LoggerFactory.getLogger(PackageRepo.class);
    static final String PACKAGES_ROOT_PATH = "/var/sling/distribution/journal/packages";
    private static final String PACKAGE_PATH_PATTERN = "/var/sling/distribution/journal/packages/%s/data/%s";

    @Nonnull
    public String store(ResourceResolver resolver, DistributionPackage disPkg) throws DistributionException {
        try {
            String pkgPath = String.format(PACKAGE_PATH_PATTERN, disPkg.getType(), disPkg.getId());
            Resource pkgResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)pkgPath, (String)SLING_FOLDER, (String)SLING_FOLDER, (boolean)false);
            Node pkgNode = (Node)pkgResource.adaptTo(Node.class);
            Node binNode = JcrUtils.getOrAddNode((Node)pkgNode, (String)"bin", (String)"{http://www.jcp.org/jcr/nt/1.0}file");
            Node cntNode = JcrUtils.getOrAddNode((Node)binNode, (String)"{http://www.jcp.org/jcr/1.0}content", (String)"{http://www.jcp.org/jcr/nt/1.0}resource");
            Binary binary = pkgNode.getSession().getValueFactory().createBinary(disPkg.createInputStream());
            cntNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
            resolver.commit();
            String blobRef = ((ReferenceBinary)binary).getReference();
            LOG.info("Stored content package {} under path {} with blobRef {}", new Object[]{disPkg.getId(), pkgPath, blobRef});
            return blobRef;
        }
        catch (Exception e) {
            throw new DistributionException(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup(long deleteOlderThanTime) {
        Timer.Context context = this.distributionMetricsService.getCleanupPackageDuration().time();
        try (ResourceResolver resolver = this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "bookkeeper"));){
            PackageCleaner packageCleaner = new PackageCleaner(resolver, deleteOlderThanTime);
            Resource root = this.getRoot(resolver);
            int removedCount = packageCleaner.cleanup(root);
            this.distributionMetricsService.getCleanupPackageRemovedCount().increment((long)removedCount);
        }
        catch (LoginException | PersistenceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            context.stop();
        }
    }

    @Nonnull
    private Resource getRoot(ResourceResolver resolver) throws PersistenceException {
        return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)PACKAGES_ROOT_PATH, (String)SLING_FOLDER, (String)SLING_FOLDER, (boolean)true);
    }
}

