/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.precondition;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.distribution.journal.HandlerAdapter;
import org.apache.sling.distribution.journal.MessageInfo;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.Reset;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.journal.messages.Messages;

public class PackageStatusWatcher
implements Closeable {
    private final Closeable poller;
    private final Map<String, Map<Long, Messages.PackageStatusMessage.Status>> pkgStatusPerSubAgent = new ConcurrentHashMap<String, Map<Long, Messages.PackageStatusMessage.Status>>();

    public PackageStatusWatcher(MessagingProvider messagingProvider, Topics topics) {
        String topicName = topics.getStatusTopic();
        this.poller = messagingProvider.createPoller(topicName, Reset.earliest, new HandlerAdapter[]{HandlerAdapter.create(Messages.PackageStatusMessage.class, this::handle)});
    }

    public Messages.PackageStatusMessage.Status getStatus(String subAgentName, long pkgOffset) {
        Map<Long, Messages.PackageStatusMessage.Status> statusPerAgent = this.getAgentStatus(subAgentName);
        return statusPerAgent.get(pkgOffset);
    }

    private Map<Long, Messages.PackageStatusMessage.Status> getAgentStatus(String subAgentName) {
        return this.pkgStatusPerSubAgent.computeIfAbsent(subAgentName, this::newMap);
    }

    private Map<Long, Messages.PackageStatusMessage.Status> newMap(String subAgentName) {
        return new ConcurrentHashMap<Long, Messages.PackageStatusMessage.Status>();
    }

    @Override
    public void close() throws IOException {
        this.poller.close();
    }

    private void handle(MessageInfo info, Messages.PackageStatusMessage pkgStatusMsg) {
        Map<Long, Messages.PackageStatusMessage.Status> agentStatus = this.getAgentStatus(pkgStatusMsg.getSubAgentName());
        agentStatus.put(pkgStatusMsg.getOffset(), pkgStatusMsg.getStatus());
    }
}

