/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.event;

import java.util.HashMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.messages.Messages;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.osgi.service.event.Event;

@ParametersAreNonnullByDefault
public class DistributionEvent {
    public static final String PACKAGE_ID = "distribution.package.id";
    private static final String KIND_AGENT = "agent";
    private static final String KIND_IMPORTER = "importer";

    private DistributionEvent() {
    }

    public static Event eventImporterImported(Messages.PackageMessage pkgMsg, String agentName) {
        return DistributionEvent.buildEvent("org/apache/sling/distribution/importer/package/imported", KIND_IMPORTER, agentName, pkgMsg);
    }

    public static Event eventPackageCreated(Messages.PackageMessage pkgMsg, String agentName) {
        return DistributionEvent.buildEvent("org/apache/sling/distribution/agent/package/created", KIND_AGENT, agentName, pkgMsg);
    }

    public static Event eventPackageDistributed(DistributionQueueItem queueItem, String agentName) {
        return DistributionEvent.buildEvent("org/apache/sling/distribution/agent/package/distributed", KIND_AGENT, agentName, (String)queueItem.get("request.type", String.class), (String[])queueItem.get("request.paths", String[].class), queueItem.getPackageId());
    }

    public static Event eventPackageQueued(Messages.PackageMessage pkgMsg, String agentName) {
        return DistributionEvent.buildEvent("org/apache/sling/distribution/agent/package/queued", KIND_AGENT, agentName, pkgMsg);
    }

    private static Event buildEvent(String topic, String kind, String agentName, Messages.PackageMessage pkgMsg) {
        List pathsList = pkgMsg.getPathsList();
        return DistributionEvent.buildEvent(topic, kind, agentName, pkgMsg.getReqType().name(), pathsList.toArray(new String[0]), pkgMsg.getPkgId());
    }

    private static Event buildEvent(String topic, String kind, String agentName, String reqType, String[] paths, String packageId) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("distribution.component.kind", kind);
        props.put("distribution.component.name", agentName);
        props.put("distribution.type", reqType);
        props.put("distribution.paths", paths);
        props.put(PACKAGE_ID, packageId);
        return new Event(topic, props);
    }
}

