/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.impl.shared.PackageBrowser;
import org.apache.sling.distribution.journal.impl.subscriber.ContentPackageExtractor;
import org.apache.sling.distribution.journal.messages.Messages;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PackageHandler.class);
    private DistributionPackageBuilder packageBuilder;
    private ContentPackageExtractor extractor;

    public PackageHandler(DistributionPackageBuilder packageBuilder, ContentPackageExtractor extractor) {
        this.packageBuilder = packageBuilder;
        this.extractor = extractor;
    }

    public void apply(ResourceResolver resolver, Messages.PackageMessage pkgMsg) throws DistributionException, PersistenceException {
        Messages.PackageMessage.ReqType type = pkgMsg.getReqType();
        switch (type) {
            case ADD: {
                this.installAddPackage(resolver, pkgMsg);
                break;
            }
            case DELETE: {
                this.installDeletePackage(resolver, pkgMsg);
                break;
            }
            case TEST: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to process messages with type: %s", type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installAddPackage(ResourceResolver resolver, Messages.PackageMessage pkgMsg) throws DistributionException {
        LOG.info("Importing paths {}", (Object)pkgMsg.getPathsList());
        InputStream pkgStream = null;
        try {
            pkgStream = PackageBrowser.pkgStream(resolver, pkgMsg);
            this.packageBuilder.installPackage(resolver, pkgStream);
            this.extractor.handle(resolver, pkgMsg.getPathsList());
        }
        finally {
            IOUtils.closeQuietly((InputStream)pkgStream);
        }
    }

    private void installDeletePackage(ResourceResolver resolver, Messages.PackageMessage pkgMsg) throws PersistenceException {
        LOG.info("Deleting paths {}", (Object)pkgMsg.getPathsList());
        for (String path : pkgMsg.getPathsList()) {
            Resource resource = resolver.getResource(path);
            if (resource == null) continue;
            resolver.delete(resource);
        }
    }
}

