/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.io.Closeable;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.impl.shared.ExponentialBackOff;
import org.apache.sling.distribution.journal.impl.shared.JournalAvailableServiceMarker;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventHandler.class}, property={"event.topics=org/apache/sling/distribution/journal/errors"})
@Designate(ocd=JournalCheckerConfiguration.class)
public class JournalAvailableChecker
implements EventHandler {
    public static final long INITIAL_RETRY_DELAY = 60000L;
    public static final long MAX_RETRY_DELAY = 1800000L;
    private static final Logger LOG = LoggerFactory.getLogger(JournalAvailableChecker.class);
    private ExponentialBackOff backoffRetry;
    @Reference
    Topics topics;
    @Reference
    MessagingProvider provider;
    @Reference
    DistributionMetricsService metrics;
    private JournalAvailableServiceMarker marker;
    private DistributionMetricsService.GaugeService<Boolean> gauge;

    @Activate
    public void activate(JournalCheckerConfiguration config, BundleContext context) {
        Objects.requireNonNull(this.provider);
        Objects.requireNonNull(this.topics);
        this.backoffRetry = new ExponentialBackOff(config.initialRetryDelay(), config.maxRetryDelay(), true, this::run);
        this.marker = new JournalAvailableServiceMarker(context);
        this.gauge = this.metrics.createGauge("distribution.journal.journal_available", "", this::isAvailable);
        this.marker.register();
        LOG.info("Started Journal availability checker service with initialRetryDelay {}, maxRetryDelay {}. Journal is initially assumed available.", (Object)config.initialRetryDelay(), (Object)config.maxRetryDelay());
    }

    @Deactivate
    public void deactivate() {
        this.gauge.close();
        this.marker.unRegister();
        IOUtils.closeQuietly((Closeable)this.backoffRetry);
        LOG.info("Stopped Journal availability checker service");
    }

    private void doChecks() {
        this.provider.assertTopic(this.topics.getPackageTopic());
        this.provider.assertTopic(this.topics.getDiscoveryTopic());
        this.provider.assertTopic(this.topics.getStatusTopic());
        this.provider.assertTopic(this.topics.getCommandTopic());
    }

    private void available() {
        LOG.info("Journal is available");
        this.marker.register();
    }

    private void stillUnAvailable(Exception e) {
        String msg = "Journal is still unavailable: " + e.getMessage();
        LOG.warn(msg, (Throwable)e);
        this.marker.unRegister();
    }

    public boolean isAvailable() {
        return this.marker.isRegistered();
    }

    public void run() {
        try {
            LOG.debug("Journal checker is running");
            this.doChecks();
            this.available();
        }
        catch (Exception e) {
            this.stillUnAvailable(e);
            throw e;
        }
    }

    public synchronized void handleEvent(Event event) {
        String type = (String)event.getProperty("type");
        if (this.marker.isRegistered()) {
            LOG.warn("Received exception event {}. Journal is considered unavailable.", (Object)type);
            this.marker.unRegister();
            this.backoffRetry.startChecks();
        } else {
            LOG.info("Received exception event {}. Journal still unavailable.", (Object)type);
        }
    }

    @ObjectClassDefinition(name="Apache Sling Journal based Distribution - Journal Checker")
    public static @interface JournalCheckerConfiguration {
        @AttributeDefinition(name="Initial retry delay", description="The initial retry delay in milliseconds.")
        public long initialRetryDelay() default 60000L;

        @AttributeDefinition(name="Max retry delay", description="The max retry delay in milliseconds.")
        public long maxRetryDelay() default 1800000L;
    }
}

