/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.queue.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.impl.queue.impl.EntryUtil;
import org.apache.sling.distribution.journal.impl.queue.impl.PackageRetries;
import org.apache.sling.distribution.journal.impl.queue.impl.QueueEntryFactory;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SubQueue
implements DistributionQueue {
    private static final String UNSUPPORTED_CLEAR_OPERATION = "Unsupported clear operation";
    private static final Logger LOG = LoggerFactory.getLogger(SubQueue.class);
    private final DistributionQueueItem headItem;
    private final PackageRetries packageRetries;
    private final String queueName;
    private final QueueEntryFactory entryFactory;

    public SubQueue(String queueName, @Nullable DistributionQueueItem headItem, PackageRetries packageRetries) {
        this.headItem = headItem;
        this.queueName = Objects.requireNonNull(queueName);
        this.packageRetries = Objects.requireNonNull(packageRetries);
        this.entryFactory = new QueueEntryFactory(queueName, this::attempts);
    }

    @Nonnull
    public String getName() {
        return this.queueName;
    }

    public DistributionQueueEntry add(DistributionQueueItem queueItem) {
        throw new UnsupportedOperationException("Unsupported add operation");
    }

    @CheckForNull
    public DistributionQueueEntry getHead() {
        return this.entryFactory.create(this.headItem);
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> getEntries(int skip, int limit) {
        List<Object> entries = skip == 0 && (limit == -1 || limit > 0) && this.headItem != null ? Collections.singletonList(this.entryFactory.create(this.headItem)) : Collections.emptyList();
        return Collections.unmodifiableList(entries);
    }

    public DistributionQueueEntry getEntry(String entryId) {
        return entryId.equals(EntryUtil.entryId(this.headItem)) ? this.entryFactory.create(this.headItem) : null;
    }

    public DistributionQueueEntry remove(String entryId) {
        throw new UnsupportedOperationException(UNSUPPORTED_CLEAR_OPERATION);
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> remove(Set<String> entryIds) {
        throw new UnsupportedOperationException(UNSUPPORTED_CLEAR_OPERATION);
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> clear(int limit) {
        throw new UnsupportedOperationException(UNSUPPORTED_CLEAR_OPERATION);
    }

    @Nonnull
    public DistributionQueueStatus getStatus() {
        DistributionQueueState queueState;
        int itemsCount;
        DistributionQueueEntry headEntry = this.getHead();
        if (headEntry != null) {
            itemsCount = 1;
            DistributionQueueItemState itemState = headEntry.getStatus().getItemState();
            queueState = itemState == DistributionQueueItemState.QUEUED ? DistributionQueueState.RUNNING : DistributionQueueState.BLOCKED;
        } else {
            itemsCount = 0;
            queueState = DistributionQueueState.IDLE;
        }
        return new DistributionQueueStatus(itemsCount, queueState);
    }

    @Nonnull
    public DistributionQueueType getType() {
        return DistributionQueueType.ORDERED;
    }

    public boolean hasCapability(String capability) {
        return false;
    }

    private int attempts(DistributionQueueItem queueItem) {
        String entryId = EntryUtil.entryId(queueItem);
        return this.packageRetries.get(entryId);
    }
}

