/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.jcr.Binary;
import javax.jcr.Node;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.Reset;
import org.apache.sling.distribution.journal.impl.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(service={PackageRepo.class})
public class PackageRepo {
    private static final String SLING_FOLDER = "sling:Folder";
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private Topics topics;
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private ServiceUserMapped mapped;
    @Reference
    private DistributionMetricsService distributionMetricsService;
    private static final Logger LOG = LoggerFactory.getLogger(PackageRepo.class);
    static final String PACKAGES_ROOT_PATH = "/var/sling/distribution/journal/packages";
    private static final String PACKAGE_PATH_PATTERN = "/var/sling/distribution/journal/packages/%s/data/%s";

    @Nonnull
    public String store(ResourceResolver resolver, DistributionPackage disPkg) throws DistributionException {
        try {
            String pkgPath = String.format(PACKAGE_PATH_PATTERN, disPkg.getType(), disPkg.getId());
            Resource pkgResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)pkgPath, (String)SLING_FOLDER, (String)SLING_FOLDER, (boolean)false);
            Node pkgNode = (Node)pkgResource.adaptTo(Node.class);
            Node binNode = JcrUtils.getOrAddNode((Node)pkgNode, (String)"bin", (String)"{http://www.jcp.org/jcr/nt/1.0}file");
            Node cntNode = JcrUtils.getOrAddNode((Node)binNode, (String)"{http://www.jcp.org/jcr/1.0}content", (String)"{http://www.jcp.org/jcr/nt/1.0}resource");
            Binary binary = pkgNode.getSession().getValueFactory().createBinary(disPkg.createInputStream());
            cntNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
            resolver.commit();
            String blobRef = ((ReferenceBinary)binary).getReference();
            LOG.info("Stored content package {} under path {} with blobRef {}", new Object[]{disPkg.getId(), pkgPath, blobRef});
            return blobRef;
        }
        catch (Exception e) {
            throw new DistributionException(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup() {
        Timer.Context context = this.distributionMetricsService.getCleanupPackageDuration().time();
        try (ResourceResolver resolver = this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "bookkeeper"));){
            long headOffset = this.messagingProvider.retrieveOffset(this.topics.getPackageTopic(), Reset.earliest);
            long tailOffset = this.messagingProvider.retrieveOffset(this.topics.getPackageTopic(), Reset.latest);
            this.cleanup(resolver, headOffset, tailOffset);
        }
        catch (LoginException | PersistenceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            context.stop();
        }
    }

    private void cleanup(ResourceResolver resolver, long headOffset, long tailOffset) throws PersistenceException {
        LOG.info("Cleanup headOffset {} tailOffset {}", (Object)headOffset, (Object)tailOffset);
        Resource root = this.getRoot(resolver);
        int removedCount = 0;
        for (Resource type : root.getChildren()) {
            Resource data = type.getChild("data");
            if (data == null) continue;
            for (Resource pkg : data.getChildren()) {
                removedCount += this.cleanNode(resolver, headOffset, tailOffset, pkg);
            }
        }
        if (resolver.hasChanges()) {
            resolver.commit();
            this.distributionMetricsService.getCleanupPackageRemovedCount().increment((long)removedCount);
        }
    }

    private int cleanNode(ResourceResolver resolver, long headOffset, long tailOffset, Resource pkg) throws PersistenceException {
        long offset = ((Integer)pkg.getValueMap().get("offset", (Object)-1)).intValue();
        if (offset < 0L) {
            LOG.info("keep package {}, setting tail offset {}", (Object)pkg.getName(), (Object)tailOffset);
            ((ModifiableValueMap)pkg.adaptTo(ModifiableValueMap.class)).put((Object)"offset", (Object)tailOffset);
        } else {
            if (offset < headOffset) {
                LOG.info("remove package {}, offset smaller than head offset {} < {}", new Object[]{pkg.getName(), offset, headOffset});
                resolver.delete(pkg);
                return 1;
            }
            LOG.debug("keep package {}, offset bigger or equal to head offset {} >= {}", new Object[]{pkg.getName(), offset, headOffset});
        }
        return 0;
    }

    @Nonnull
    private Resource getRoot(ResourceResolver resolver) throws PersistenceException {
        return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)PACKAGES_ROOT_PATH, (String)SLING_FOLDER, (String)SLING_FOLDER, (boolean)true);
    }
}

