/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Set;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.sling.distribution.journal.impl.publisher.DiscoveryService;
import org.apache.sling.distribution.journal.impl.publisher.DistPublisherJMXMBean;
import org.apache.sling.distribution.journal.impl.publisher.DistributionPublisher;
import org.apache.sling.distribution.journal.impl.publisher.State;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.spi.DistributionQueue;

class DistPublisherJMX
extends StandardMBean
implements DistPublisherJMXMBean {
    private static final String COL_ID = "ID";
    private static final String COL_OFFSET = "offset";
    private String pubAgentName;
    private DiscoveryService discoveryService;
    private DistributionPublisher distPublisher;

    protected DistPublisherJMX(String pubAgentName, DiscoveryService discoveryService, DistributionPublisher distPublisher) throws NotCompliantMBeanException {
        super(DistPublisherJMXMBean.class);
        this.pubAgentName = pubAgentName;
        this.discoveryService = discoveryService;
        this.distPublisher = distPublisher;
    }

    @Override
    public TabularData getOffsetPerSubscriber() throws MBeanException {
        try {
            String[] itemNames = new String[]{COL_ID, COL_OFFSET};
            OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG};
            CompositeType rowType = new CompositeType("Offsets", "Offsets by sub agent", itemNames, itemNames, itemTypes);
            TabularType type = new TabularType("type", "desc", rowType, new String[]{COL_ID});
            TabularDataSupport table = new TabularDataSupport(type);
            Set<State> subscribedAgents = this.discoveryService.getTopologyView().getSubscribedAgents(this.pubAgentName);
            for (State state : subscribedAgents) {
                CompositeDataSupport row = new CompositeDataSupport(rowType, itemNames, new Object[]{state.getSubAgentId(), state.getOffset()});
                table.put(row);
            }
            return table;
        }
        catch (OpenDataException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public TabularData getQueue(String queueName) throws MBeanException {
        try {
            String[] itemNames = new String[]{COL_ID, COL_OFFSET};
            OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG};
            CompositeType rowType = new CompositeType("Offsets", "Queue Offsets", itemNames, itemNames, itemTypes);
            TabularType type = new TabularType("type", "desc", rowType, new String[]{COL_ID});
            TabularDataSupport table = new TabularDataSupport(type);
            DistributionQueue queue = this.distPublisher.getQueue(queueName);
            if (queue != null) {
                for (DistributionQueueEntry item : queue.getEntries(0, 1000)) {
                    CompositeDataSupport row = new CompositeDataSupport(rowType, itemNames, new Object[]{item.getId(), item.getItem().get((Object)COL_OFFSET)});
                    table.put(row);
                }
            }
            return table;
        }
        catch (OpenDataException e) {
            throw new MBeanException(e);
        }
    }
}

