/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.precondition;

import java.io.Closeable;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.precondition.PackageStatusWatcher;
import org.apache.sling.distribution.journal.impl.precondition.Precondition;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.journal.messages.Messages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"name=staging", "scheduler.concurrent:Boolean=false", "scheduler.period:Long=86400"})
public class StagingPrecondition
implements Precondition,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StagingPrecondition.class);
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private Topics topics;
    private volatile PackageStatusWatcher watcher;
    private volatile boolean running = true;

    @Activate
    public void activate() {
        this.watcher = new PackageStatusWatcher(this.messagingProvider, this.topics);
        LOG.info("Activated Staging Precondition");
    }

    @Deactivate
    public synchronized void deactivate() {
        IOUtils.closeQuietly((Closeable)this.watcher);
        this.running = false;
    }

    @Override
    public boolean canProcess(String subAgentName, long pkgOffset, int timeoutSeconds) throws InterruptedException, TimeoutException {
        if (timeoutSeconds < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < timeoutSeconds * 10; ++i) {
            Messages.PackageStatusMessage.Status status = this.getStatus(subAgentName, pkgOffset);
            if (status != null) {
                return status == Messages.PackageStatusMessage.Status.IMPORTED;
            }
            Thread.sleep(100L);
            if (this.running) continue;
            throw new InterruptedException("Staging precondition is shutting down");
        }
        throw new TimeoutException("Timeout waiting for package offset " + pkgOffset + " on status topic.");
    }

    private synchronized Messages.PackageStatusMessage.Status getStatus(String subAgentName, long pkgOffset) {
        return this.watcher.getStatus(subAgentName, pkgOffset);
    }

    @Override
    public synchronized void run() {
        LOG.info("Purging StagingPrecondition cache");
        IOUtils.closeQuietly((Closeable)this.watcher);
        this.watcher = new PackageStatusWatcher(this.messagingProvider, this.topics);
    }
}

