/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.Closeable;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.journal.impl.subscriber.PackageStatusWatcher;
import org.apache.sling.distribution.journal.impl.subscriber.Precondition;
import org.apache.sling.distribution.journal.messages.Messages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Precondition.class}, property={"name=staging"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class StagingPrecondition
implements Precondition {
    private static final Logger LOG = LoggerFactory.getLogger(StagingPrecondition.class);
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private Topics topics;
    private volatile PackageStatusWatcher watcher;
    private volatile boolean running = true;

    @Activate
    public void activate(Configuration config) {
        String subAgentName = config.subAgentName();
        this.watcher = new PackageStatusWatcher(this.messagingProvider, this.topics, subAgentName);
        LOG.info("Activated Staging Precondition for subAgentName {}", (Object)subAgentName);
    }

    @Deactivate
    public void deactivate() {
        IOUtils.closeQuietly((Closeable)this.watcher);
        this.running = false;
    }

    @Override
    public boolean canProcess(long pkgOffset, int timeoutSeconds) {
        if (timeoutSeconds < 1) {
            throw new IllegalArgumentException();
        }
        this.watcher.clear(pkgOffset);
        for (int i = 0; this.running && i < timeoutSeconds; ++i) {
            Messages.PackageStatusMessage.Status status = this.watcher.getStatus(pkgOffset);
            if (status != null) {
                return status == Messages.PackageStatusMessage.Status.IMPORTED;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Timeout waiting for package offset " + pkgOffset + " on status topic.");
    }

    @ObjectClassDefinition(name="Apache Sling Journal based Distribution - Staged Distribution Precondition", description="Apache Sling Content Distribution Sub Agent precondition for staged replication")
    public static @interface Configuration {
        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Agent name: {subAgentName}";

        @AttributeDefinition(name="name", description="The name of the agent to watch")
        public String subAgentName() default "";
    }
}

