/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.shared;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.agent.DistributionAgentState;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.spi.DistributionQueue;

@ParametersAreNonnullByDefault
public class AgentState {
    public static DistributionAgentState getState(DistributionAgent agent) {
        boolean empty;
        boolean bl = empty = !AgentState.queueStatuses(agent).anyMatch(AgentState::queueNotEmpty);
        if (empty) {
            return DistributionAgentState.IDLE;
        }
        boolean blocked = AgentState.queueStatuses(agent).anyMatch(AgentState::isBlocked);
        if (blocked) {
            return DistributionAgentState.BLOCKED;
        }
        return DistributionAgentState.RUNNING;
    }

    private static Stream<DistributionQueueStatus> queueStatuses(DistributionAgent agent) {
        return StreamSupport.stream(agent.getQueueNames().spliterator(), true).map(arg_0 -> ((DistributionAgent)agent).getQueue(arg_0)).map(DistributionQueue::getStatus);
    }

    private static boolean queueNotEmpty(DistributionQueueStatus queueStatus) {
        return !queueStatus.isEmpty();
    }

    private static boolean isBlocked(DistributionQueueStatus queueStatus) {
        return queueStatus.getState() == DistributionQueueState.BLOCKED;
    }
}

