/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"sling/distribution/service/trigger"}, extensions={"event"}, methods={"GET"})
public class DistributionTriggerServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int DEFAULT_NUMBER_OF_SECONDS = 60;
    private static final int MAX_NUMBER_OF_SECONDS = 3600;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        int seconds;
        String secondsParameter = request.getParameter("sec");
        int n = seconds = secondsParameter != null && secondsParameter.length() > 0 ? Integer.parseInt(secondsParameter) : 60;
        if (seconds > 3600) {
            seconds = 3600;
        } else if (seconds < 0) {
            seconds = 60;
        }
        DistributionTrigger distributionTrigger = (DistributionTrigger)request.getResource().adaptTo(DistributionTrigger.class);
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        final PrintWriter writer = response.getWriter();
        DistributionRequestHandler distributionRequestHandler = new DistributionRequestHandler(){

            @Override
            public String getName() {
                return ((Object)((Object)DistributionTriggerServlet.this)).getClass().getSimpleName();
            }

            @Override
            public DistributionComponentKind getComponentKind() {
                return null;
            }

            @Override
            public void handle(@Nullable ResourceResolver resourceResolver, @NotNull DistributionRequest request) {
                DistributionTriggerServlet.this.writeEvent(writer, request);
            }
        };
        try {
            distributionTrigger.register(distributionRequestHandler);
            try {
                Thread.sleep(seconds * 1000);
            }
            catch (InterruptedException e) {
                this.log.error("thread interrupted", (Throwable)e);
            }
            distributionTrigger.unregister(distributionRequestHandler);
        }
        catch (DistributionException e) {
            response.setStatus(400);
            response.getWriter().write("error while (un)registering trigger " + e.toString());
        }
    }

    private void writeEvent(PrintWriter writer, DistributionRequest distributionRequest) {
        writer.write("id: " + System.currentTimeMillis() + "\n");
        writer.write("data: " + distributionRequest.getRequestType() + " " + Arrays.toString(distributionRequest.getPaths()) + "\n\n");
        writer.flush();
        this.log.debug("SSE event {} {}", (Object)distributionRequest.getRequestType(), (Object)distributionRequest.getPaths());
    }
}

