/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.component.impl.DistributionConfigurationManager;
import org.apache.sling.distribution.resources.impl.DistributionConfigurationResourceProvider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Distribution Resources - Configuration Resource Provider Factory", description="Distribution Configuration Resource Provider Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={ResourceProviderFactory.class})
@Properties(value={@Property(name="provider.roots"), @Property(name="provider.ownsRoots", boolValue={true}, propertyPrivate=true)})
@Property(name="webconsole.configurationFactory.nameHint", value={"Resource kind: {kind}"})
public class DistributionConfigurationResourceProviderFactory
implements ResourceProviderFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property
    private static final String KIND = "kind";
    @Reference
    private DistributionConfigurationManager configurationManager;
    private String resourceRoot;
    private String kind;

    @Activate
    public void activate(BundleContext context, Map<String, Object> properties) {
        this.log.debug("activating resource provider with config {}", properties);
        this.resourceRoot = PropertiesUtil.toString((Object)properties.get("provider.roots"), null);
        this.kind = PropertiesUtil.toString((Object)properties.get(KIND), null);
    }

    @Deactivate
    public void deactivate(BundleContext context) {
    }

    public ResourceProvider getResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        return new DistributionConfigurationResourceProvider(this.configurationManager, this.kind, this.resourceRoot);
    }

    public ResourceProvider getAdministrativeResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceProvider(authenticationInfo);
    }

    protected void bindConfigurationManager(DistributionConfigurationManager distributionConfigurationManager) {
        this.configurationManager = distributionConfigurationManager;
    }

    protected void unbindConfigurationManager(DistributionConfigurationManager distributionConfigurationManager) {
        if (this.configurationManager == distributionConfigurationManager) {
            this.configurationManager = null;
        }
    }
}

