/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueProviderFactory;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueProvider;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Resource Queue Provider Factory", description="OSGi configuration factory for Resource-backed queues", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionQueueProviderFactory.class})
@Properties(value={@Property(name="name", value={"resourceQueue"}), @Property(name="queue.isActive", label="Should the Resource-backed queue created with a Queue Processor (i.e., ACTIVE)", boolValue={false})})
public class ResourceQueueProviderFactory
implements DistributionQueueProviderFactory {
    static final String PN_IS_ACTIVE = "queue.isActive";
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    @Reference
    Scheduler scheduler;
    BundleContext context;
    private boolean isActive;

    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        this.isActive = PropertiesUtil.toBoolean((Object)PN_IS_ACTIVE, (boolean)false);
        this.context = context;
    }

    @Override
    public DistributionQueueProvider getProvider(String agentName, String serviceName) {
        return new ResourceQueueProvider(this.context, this.resourceResolverFactory, serviceName, agentName, this.scheduler, this.isActive);
    }

    @Override
    public void releaseProvider(DistributionQueueProvider queueProvider) {
        if (queueProvider instanceof ResourceQueueProvider) {
            ((ResourceQueueProvider)queueProvider).close();
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }
}

