/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"sling/distribution/service/exporter"}, methods={"POST"})
public class DistributionPackageExporterServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String operation = request.getParameter("operation");
        try {
            if ("delete".equals(operation)) {
                this.deletePackage(request, response);
            } else if ("fetch".equals(operation)) {
                this.exportOnePackage(request, response, false);
            } else {
                this.exportOnePackage(request, response, true);
            }
        }
        catch (Throwable t) {
            response.setStatus(503);
            this.log.error("error while exporting package", t);
        }
    }

    private void exportOnePackage(SlingHttpServletRequest request, final SlingHttpServletResponse response, final boolean delete) throws ServletException, IOException {
        DistributionPackageExporter distributionPackageExporter = (DistributionPackageExporter)request.getResource().adaptTo(DistributionPackageExporter.class);
        long start = System.currentTimeMillis();
        response.setContentType(ContentType.APPLICATION_OCTET_STREAM.toString());
        DistributionRequest distributionRequest = RequestUtils.fromServletRequest((HttpServletRequest)request);
        ResourceResolver resourceResolver = request.getResourceResolver();
        final AtomicInteger fetched = new AtomicInteger(0);
        try {
            distributionPackageExporter.exportPackages(resourceResolver, distributionRequest, new DistributionPackageProcessor(){

                @Override
                public void process(DistributionPackage distributionPackage) {
                    fetched.incrementAndGet();
                    InputStream inputStream = null;
                    int bytesCopied = -1;
                    try {
                        inputStream = DistributionPackageUtils.createStreamWithHeader(distributionPackage);
                        bytesCopied = IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("cannot process package", e);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                    String packageId = distributionPackage.getId();
                    if (delete) {
                        distributionPackage.delete();
                    }
                    response.setStatus(200);
                    DistributionPackageExporterServlet.this.log.debug("exported package {} was sent (and deleted={}), bytes written {}", new Object[]{packageId, delete, bytesCopied});
                }

                @Override
                public List<DistributionResponse> getAllResponses() {
                    return null;
                }

                @Override
                public int getPackagesCount() {
                    return 0;
                }

                @Override
                public long getPackagesSize() {
                    return 0L;
                }
            });
            if (fetched.get() > 0) {
                long end = System.currentTimeMillis();
                this.log.info("Processed distribution export request in {} ms: : fetched {}", (Object)(end - start), (Object)fetched);
            } else {
                response.setStatus(204);
                this.log.debug("nothing to fetch");
            }
        }
        catch (Throwable e) {
            response.setStatus(503);
            this.log.error("error while exporting package", e);
        }
    }

    private void deletePackage(SlingHttpServletRequest request, SlingHttpServletResponse response) throws DistributionException {
        String id;
        ResourceResolver resourceResolver;
        DistributionPackageExporter distributionPackageExporter = (DistributionPackageExporter)request.getResource().adaptTo(DistributionPackageExporter.class);
        DistributionPackage distributionPackage = distributionPackageExporter.getPackage(resourceResolver = request.getResourceResolver(), id = request.getParameter("id"));
        if (distributionPackage != null) {
            distributionPackage.delete();
            this.log.debug("exported package {} was deleted", (Object)distributionPackage.getId());
            response.setStatus(200);
        } else {
            response.setStatus(204);
            this.log.debug("nothing to delete {}", (Object)id);
        }
    }
}

