/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDistributionPackage
extends AbstractDistributionPackage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public FileDistributionPackage(@NotNull File file, @NotNull String type, @Nullable String digestAlgorithm, @Nullable String digestMessage, @Nullable Map<String, Object> baseInfoMap) {
        super(file.getName(), type, digestAlgorithm, digestMessage);
        Throwable throwable;
        this.file = file;
        if (null == baseInfoMap) {
            try {
                throwable = null;
                try (FileInputStream metaInfoIS = FileUtils.openInputStream((File)this.getMetaInfoFile());){
                    DistributionPackageUtils.readInfo(metaInfoIS, (Map<String, Object>)((Object)this.getInfo()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                this.log.error("cannot read meta-info for the package at {}", (Object)file.getAbsoluteFile(), (Object)e);
            }
        }
        this.getInfo().put("request.type", DistributionRequestType.ADD);
        if (null != baseInfoMap) {
            this.getInfo().putAll(baseInfoMap);
            try {
                throwable = null;
                try (FileOutputStream metaInfoOS = FileUtils.openOutputStream((File)this.getMetaInfoFile(), (boolean)false);){
                    DistributionPackageUtils.writeInfo(metaInfoOS, baseInfoMap);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                this.log.error("cannot create meta-info for the package at {}", (Object)file.getAbsoluteFile(), (Object)e);
            }
        }
    }

    @Override
    @NotNull
    public InputStream createInputStream() throws IOException {
        return new PackageInputStream(this.file);
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
        FileUtils.deleteQuietly((File)this.file);
        FileUtils.deleteQuietly((File)this.getStatusFile());
        FileUtils.deleteQuietly((File)this.getMetaInfoFile());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void acquire(String ... holderNames) {
        try {
            DistributionPackageUtils.acquire(this.getStatusFile(), holderNames);
        }
        catch (IOException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
    }

    @Override
    public void release(String ... holderNames) {
        try {
            boolean doDelete = DistributionPackageUtils.release(this.getStatusFile(), holderNames);
            if (doDelete) {
                this.delete();
            }
        }
        catch (IOException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
    }

    private File getStatusFile() {
        String statusFilePath = this.file.getAbsolutePath() + ".status";
        return new File(statusFilePath);
    }

    private File getMetaInfoFile() {
        String metaInfoFilePath = this.file.getAbsolutePath() + ".metainfo";
        return new File(metaInfoFilePath);
    }

    public class PackageInputStream
    extends BufferedInputStream {
        private final File file;

        public PackageInputStream(File file) throws IOException {
            super(FileUtils.openInputStream((File)file));
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

