/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization.impl;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.monitor.impl.MonitoringDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.FileDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.InMemoryDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackageCleanup;
import org.apache.sling.distribution.serialization.DistributionContentSerializer;
import org.apache.sling.distribution.util.impl.FileBackedMemoryOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(metatype=true, label="Apache Sling Distribution Packaging - Package Builder Factory", description="OSGi configuration for package builders", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageBuilder.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Builder name: {name}"})
public class DistributionPackageBuilderFactory
implements DistributionPackageBuilder {
    @Property(label="Name", description="The name of the package builder.")
    private static final String NAME = "name";
    @Property(options={@PropertyOption(name="resource", value="resource packages"), @PropertyOption(name="file", value="file packages"), @PropertyOption(name="inmemory", value="in memory packages")}, value={"resource"}, label="type", description="The persistence type used by this package builder")
    private static final String PERSISTENCE = "type";
    @Property(name="format.target", label="Content Serializer", description="The target reference for the DistributionSerializationFormat used to (de)serialize packages, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="format")
    private DistributionContentSerializer contentSerializer;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Property(label="Temp Filesystem Folder", description="The filesystem folder where the temporary files should be saved.")
    private static final String TEMP_FS_FOLDER = "tempFsFolder";
    private static final int DEFAULT_FILE_THRESHOLD_VALUE = 1;
    @Property(label="File threshold", description="Once the data reaches the configurable size value, buffering to memory switches to file buffering.", intValue={1})
    public static final String FILE_THRESHOLD = "fileThreshold";
    private static final String DEFAULT_MEMORY_UNIT = "MEGA_BYTES";
    @Property(label="The memory unit for the file threshold", description="The memory unit for the file threshold, Megabytes by default", value={"MEGA_BYTES"}, options={@PropertyOption(name="BYTES", value="Bytes"), @PropertyOption(name="KILO_BYTES", value="Kilobytes"), @PropertyOption(name="MEGA_BYTES", value="Megabytes"), @PropertyOption(name="GIGA_BYTES", value="Gigabytes")})
    private static final String MEMORY_UNIT = "memoryUnit";
    private static final boolean DEFAULT_USE_OFF_HEAP_MEMORY = false;
    @Property(label="Flag to enable/disable the off-heap memory", description="Flag to enable/disable the off-heap memory, false by default", boolValue={false})
    public static final String USE_OFF_HEAP_MEMORY = "useOffHeapMemory";
    private static final String DEFAULT_DIGEST_ALGORITHM = "NONE";
    @Property(label="The digest algorithm to calculate the package checksum", description="The digest algorithm to calculate the package checksum, Megabytes by default", value={"NONE"}, options={@PropertyOption(name="NONE", value="Do not send digest"), @PropertyOption(name="MD2", value="md2"), @PropertyOption(name="MD5", value="md5"), @PropertyOption(name="SHA-1", value="sha1"), @PropertyOption(name="SHA-256", value="sha256"), @PropertyOption(name="SHA-384", value="sha384"), @PropertyOption(name="SHA-512", value="sha512")})
    private static final String DIGEST_ALGORITHM = "digestAlgorithm";
    private static final int DEFAULT_MONITORING_QUEUE_SIZE = 0;
    @Property(label="The number of items for monitoring distribution packages creation/installation", description="The number of items for monitoring distribution packages creation/installation, 100 by default", intValue={0})
    private static final String MONITORING_QUEUE_SIZE = "monitoringQueueSize";
    private static final long DEFAULT_PACKAGE_CLEANUP_DELAY = 60L;
    @Property(label="The delay in seconds between two runs of the cleanup phase for resource persisted packages.", description="The resource persisted packages are cleaned up periodically (asynchronously) since SLING-6503.The delay between two runs of the cleanup phase can be configured with this setting. 60 seconds by default", longValue={60L})
    private static final String PACKAGE_CLEANUP_DELAY = "cleanupDelay";
    @Property(label="Package Node Filters", description="The package node path filters. Filter format: path|+include|-exclude", cardinality=100)
    private static final String PACKAGE_FILTERS = "package.filters";
    @Property(label="Package Property Filters", description="The package property path filters. Filter format: path|+include|-exclude", unbounded=PropertyUnbounded.ARRAY, value={})
    private static final String PROPERTY_FILTERS = "property.filters";
    private MonitoringDistributionPackageBuilder packageBuilder;
    private ServiceRegistration<Runnable> packageCleanup = null;

    @Activate
    public void activate(BundleContext context, Map<String, Object> config) {
        AbstractDistributionPackageBuilder wrapped;
        String[] nodeFilters = SettingsUtils.removeEmptyEntries(PropertiesUtil.toStringArray((Object)config.get(PACKAGE_FILTERS), null));
        String[] propertyFilters = SettingsUtils.removeEmptyEntries(PropertiesUtil.toStringArray((Object)config.get(PROPERTY_FILTERS), null));
        String persistenceType = PropertiesUtil.toString((Object)config.get(PERSISTENCE), null);
        String tempFsFolder = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(TEMP_FS_FOLDER), null));
        String digestAlgorithm = PropertiesUtil.toString((Object)config.get(DIGEST_ALGORITHM), (String)DEFAULT_DIGEST_ALGORITHM);
        long cleanupDelay = PropertiesUtil.toLong((Object)config.get(PACKAGE_CLEANUP_DELAY), (long)60L);
        if (DEFAULT_DIGEST_ALGORITHM.equals(digestAlgorithm)) {
            digestAlgorithm = null;
        }
        if ("file".equals(persistenceType)) {
            wrapped = new FileDistributionPackageBuilder(this.contentSerializer.getName(), this.contentSerializer, tempFsFolder, digestAlgorithm, nodeFilters, propertyFilters);
        } else if ("inmemory".equals(persistenceType)) {
            wrapped = new InMemoryDistributionPackageBuilder(this.contentSerializer.getName(), this.contentSerializer, nodeFilters, propertyFilters);
        } else {
            int fileThreshold = PropertiesUtil.toInteger((Object)config.get(FILE_THRESHOLD), (int)1);
            String memoryUnitName = PropertiesUtil.toString((Object)config.get(MEMORY_UNIT), (String)DEFAULT_MEMORY_UNIT);
            FileBackedMemoryOutputStream.MemoryUnit memoryUnit = FileBackedMemoryOutputStream.MemoryUnit.valueOf(memoryUnitName);
            boolean useOffHeapMemory = PropertiesUtil.toBoolean((Object)config.get(USE_OFF_HEAP_MEMORY), (boolean)false);
            ResourceDistributionPackageBuilder resourceDistributionPackageBuilder = new ResourceDistributionPackageBuilder(this.contentSerializer.getName(), this.contentSerializer, tempFsFolder, fileThreshold, memoryUnit, useOffHeapMemory, digestAlgorithm, nodeFilters, propertyFilters);
            ResourceDistributionPackageCleanup cleanup = new ResourceDistributionPackageCleanup(this.resolverFactory, resourceDistributionPackageBuilder);
            Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
            ((Dictionary)props).put("scheduler.concurrent", false);
            ((Dictionary)props).put("scheduler.period", cleanupDelay);
            this.packageCleanup = context.registerService(Runnable.class, (Object)cleanup, props);
            wrapped = resourceDistributionPackageBuilder;
        }
        int monitoringQueueSize = PropertiesUtil.toInteger((Object)config.get(MONITORING_QUEUE_SIZE), (int)0);
        this.packageBuilder = new MonitoringDistributionPackageBuilder(monitoringQueueSize, wrapped, context);
    }

    @Deactivate
    public void deactivate() {
        this.packageBuilder.clear();
        if (this.packageCleanup != null) {
            this.packageCleanup.unregister();
        }
    }

    @Override
    public String getType() {
        return this.packageBuilder.getType();
    }

    @Override
    @NotNull
    public DistributionPackage createPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request) throws DistributionException {
        return this.packageBuilder.createPackage(resourceResolver, request);
    }

    @Override
    @NotNull
    public DistributionPackage readPackage(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.packageBuilder.readPackage(resourceResolver, stream);
    }

    @Override
    @Nullable
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String id) throws DistributionException {
        return this.packageBuilder.getPackage(resourceResolver, id);
    }

    @Override
    public boolean installPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        return this.packageBuilder.installPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo installPackage(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.packageBuilder.installPackage(resourceResolver, stream);
    }

    protected void bindFormat(DistributionContentSerializer distributionContentSerializer) {
        this.contentSerializer = distributionContentSerializer;
    }

    protected void unbindFormat(DistributionContentSerializer distributionContentSerializer) {
        if (this.contentSerializer == distributionContentSerializer) {
            this.contentSerializer = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

