/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.util.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;

public final class DigestUtils {
    private DigestUtils() {
    }

    public static DigestInputStream openDigestInputStream(InputStream mainInputStream, String digestAlgorithm) {
        return new DigestInputStream(mainInputStream, DigestUtils.getDigest(digestAlgorithm));
    }

    public static DigestOutputStream openDigestOutputStream(OutputStream mainOutputStream, String digestAlgorithm) {
        return new DigestOutputStream(mainOutputStream, DigestUtils.getDigest(digestAlgorithm));
    }

    private static MessageDigest getDigest(String digestAlgorithm) {
        try {
            return MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Digest algorithm " + digestAlgorithm + " not supported in this version.");
        }
    }

    public static String readDigestMessage(DigestInputStream input) {
        return DigestUtils.readDigestMessage(input.getMessageDigest());
    }

    public static String readDigestMessage(DigestOutputStream output) {
        return DigestUtils.readDigestMessage(output.getMessageDigest());
    }

    private static String readDigestMessage(MessageDigest messageDigest) {
        StringWriter writer = new StringWriter();
        try {
            DigestUtils.readDigest(messageDigest, writer);
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return writer.toString();
    }

    public static File rewriteDigestMessage(DigestOutputStream digestOutput, File target) throws IOException {
        File targetDigest = new File(target.getParentFile(), target.getName() + '.' + digestOutput.getMessageDigest().getAlgorithm().toLowerCase().replace('-', '\u0000'));
        DigestUtils.rewriteDigestMessage(digestOutput, new FileOutputStream(targetDigest));
        return targetDigest;
    }

    private static void rewriteDigestMessage(DigestOutputStream digestOutput, OutputStream target) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(target);
        try {
            DigestUtils.readDigest(digestOutput.getMessageDigest(), writer);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)target);
        }
    }

    private static void readDigest(MessageDigest messageDigest, Writer writer) throws IOException {
        byte[] data;
        for (byte element : data = messageDigest.digest()) {
            int intVal = element & 0xFF;
            if (intVal < 16) {
                writer.append('0');
            }
            writer.append(Integer.toHexString(intVal));
        }
    }
}

