/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueProviderFactory;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueProvider;
import org.osgi.framework.BundleContext;

@Component
@Service(value={DistributionQueueProviderFactory.class})
@Property(name="name", value={"resourceQueue"})
public class ResourceQueueProviderFactory
implements DistributionQueueProviderFactory {
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    BundleContext context;

    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        this.context = context;
    }

    @Override
    public DistributionQueueProvider getProvider(String agentName, String serviceName) {
        return new ResourceQueueProvider(this.context, this.resourceResolverFactory, serviceName, agentName);
    }

    @Override
    public void releaseProvider(DistributionQueueProvider queueProvider) {
        if (queueProvider instanceof ResourceQueueProvider) {
            ((ResourceQueueProvider)queueProvider).close();
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

