/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueue;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueCleanupTask;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ResourceQueueProvider
implements DistributionQueueProvider {
    private static final String QUEUES_ROOT = "/var/sling/distribution/queues/";
    private ResourceResolverFactory resolverFactory;
    private String serviceName;
    private String agentRootPath;
    private ServiceRegistration cleanupTask;

    public ResourceQueueProvider(BundleContext context, ResourceResolverFactory resolverFactory, String serviceName, String agentName) {
        this.resolverFactory = resolverFactory;
        this.serviceName = serviceName;
        this.agentRootPath = QUEUES_ROOT + agentName;
        this.register(context);
    }

    @Override
    @NotNull
    public DistributionQueue getQueue(@NotNull String queueName) throws DistributionException {
        return new ResourceQueue(this.resolverFactory, this.serviceName, queueName, this.agentRootPath);
    }

    @Override
    @NotNull
    public DistributionQueue getQueue(@NotNull String queueName, @NotNull DistributionQueueType type) {
        return new ResourceQueue(this.resolverFactory, this.serviceName, queueName, this.agentRootPath);
    }

    @Override
    public void enableQueueProcessing(@NotNull DistributionQueueProcessor queueProcessor, String ... queueNames) throws DistributionException {
    }

    @Override
    public void disableQueueProcessing() throws DistributionException {
    }

    private void register(BundleContext context) {
        ResourceQueueCleanupTask cleanup = new ResourceQueueCleanupTask(this.resolverFactory, this.serviceName, this.agentRootPath);
        Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
        ((Dictionary)props).put("scheduler.concurrent", false);
        ((Dictionary)props).put("scheduler.period", 300L);
        this.cleanupTask = context.registerService(Runnable.class.getName(), (Object)cleanup, props);
    }

    public void close() {
        if (this.cleanupTask != null) {
            this.cleanupTask.unregister();
            this.cleanupTask = null;
        }
    }
}

