/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDistributionPackage
extends AbstractDistributionPackage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Resource resource;
    private final ResourceResolver resourceResolver;
    private final long size;

    ResourceDistributionPackage(Resource resource, String type, ResourceResolver resourceResolver, @Nullable String digestAlgorithm, @Nullable String digestMessage) {
        super(resource.getName(), type, digestAlgorithm, digestMessage);
        this.resourceResolver = resourceResolver;
        ValueMap valueMap = resource.getValueMap();
        assert (type.equals(valueMap.get((Object)"type"))) : "wrong resource type";
        this.resource = resource;
        Object sizeProperty = resource.getValueMap().get((Object)"size");
        this.size = sizeProperty == null ? -1L : Long.parseLong(sizeProperty.toString());
        this.getInfo().put("request.type", DistributionRequestType.ADD);
    }

    @Override
    @NotNull
    public InputStream createInputStream() throws IOException {
        try {
            return new BufferedInputStream(DistributionPackageUtils.getStream(this.resource));
        }
        catch (RepositoryException e) {
            throw new IOException("Cannot create stream", e);
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
        this.delete(true);
    }

    @Override
    public void acquire(String ... holderNames) {
        try {
            DistributionPackageUtils.acquire(this.resource, holderNames);
            if (this.resourceResolver.hasChanges()) {
                this.resourceResolver.commit();
            }
        }
        catch (RepositoryException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
        catch (PersistenceException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
    }

    @Override
    public void release(String ... holderNames) {
        try {
            DistributionPackageUtils.release(this.resource, holderNames);
            if (this.resourceResolver.hasChanges()) {
                this.resourceResolver.commit();
            }
        }
        catch (RepositoryException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
        catch (PersistenceException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
    }

    public boolean disposable() {
        try {
            return DistributionPackageUtils.disposable(this.resource);
        }
        catch (RepositoryException e) {
            this.log.error("cannot check if package is disposable", (Throwable)e);
            return false;
        }
    }

    void delete(boolean save) {
        try {
            this.resourceResolver.delete(this.resource);
            if (save) {
                this.resourceResolver.commit();
            }
        }
        catch (PersistenceException e) {
            throw new RuntimeException(e);
        }
    }
}

