/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.FileDistributionPackage;
import org.apache.sling.distribution.serialization.DistributionContentSerializer;
import org.apache.sling.distribution.serialization.DistributionExportFilter;
import org.apache.sling.distribution.serialization.DistributionExportOptions;
import org.apache.sling.distribution.serialization.impl.vlt.VltUtils;
import org.apache.sling.distribution.util.impl.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDistributionPackageBuilder
extends AbstractDistributionPackageBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File tempDirectory;
    private final String digestAlgorithm;
    private final DistributionContentSerializer distributionContentSerializer;
    private final NavigableMap<String, List<String>> nodeFilters;
    private final NavigableMap<String, List<String>> propertyFilters;

    public FileDistributionPackageBuilder(String type, DistributionContentSerializer distributionContentSerializer, String tempFilesFolder, String digestAlgorithm, String[] nodeFilters, String[] propertyFilters) {
        super(type);
        this.distributionContentSerializer = distributionContentSerializer;
        this.nodeFilters = VltUtils.parseFilters(nodeFilters);
        this.propertyFilters = VltUtils.parseFilters(propertyFilters);
        this.digestAlgorithm = digestAlgorithm;
        File tempDirectory = VltUtils.getTempFolder(tempFilesFolder);
        if (tempDirectory == null) {
            tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        }
        this.tempDirectory = tempDirectory;
    }

    @Override
    protected DistributionPackage createPackageForAdd(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request) throws DistributionException {
        FileDistributionPackage distributionPackage;
        OutputStream outputStream = null;
        String digestMessage = null;
        try {
            File file = File.createTempFile("distrpck-create-" + UUID.randomUUID(), "." + this.getType(), this.tempDirectory);
            outputStream = this.digestAlgorithm != null ? DigestUtils.openDigestOutputStream(new FileOutputStream(file), this.digestAlgorithm) : new FileOutputStream(file);
            DistributionExportFilter filter = this.distributionContentSerializer.isRequestFiltering() ? null : DistributionExportFilter.createFilter(request, this.nodeFilters, this.propertyFilters);
            DistributionExportOptions distributionExportOptions = new DistributionExportOptions(request, filter);
            this.distributionContentSerializer.exportToStream(resourceResolver, distributionExportOptions, outputStream);
            outputStream.flush();
            if (this.digestAlgorithm != null) {
                digestMessage = DigestUtils.readDigestMessage((DigestOutputStream)outputStream);
            }
            distributionPackage = new FileDistributionPackage(file, this.getType(), this.digestAlgorithm, digestMessage);
        }
        catch (IOException e) {
            try {
                throw new DistributionException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return distributionPackage;
    }

    @Override
    protected DistributionPackage readPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        FileDistributionPackage distributionPackage;
        DigestOutputStream outputStream = null;
        try {
            String name;
            HashMap<String, Object> info = new HashMap<String, Object>();
            DistributionPackageUtils.readInfo(stream, info);
            Object remoteId = info.get("remote.package.id");
            if (remoteId != null) {
                name = remoteId.toString();
                this.log.debug("preserving remote id {}", (Object)name);
            } else {
                name = "distrpck-read-" + System.nanoTime();
                this.log.debug("generating a new id {}", (Object)name);
            }
            File file = File.createTempFile(name, "." + this.getType(), this.tempDirectory);
            outputStream = DigestUtils.openDigestOutputStream(new FileOutputStream(file), this.digestAlgorithm);
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
            outputStream.flush();
            String digestMessage = DigestUtils.readDigestMessage(outputStream);
            distributionPackage = new FileDistributionPackage(file, this.getType(), this.digestAlgorithm, digestMessage);
        }
        catch (Exception e) {
            try {
                throw new DistributionException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return distributionPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean installPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull InputStream inputStream) throws DistributionException {
        try {
            this.distributionContentSerializer.importFromStream(resourceResolver, inputStream);
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    protected DistributionPackage getPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull String id) {
        File file = new File(this.tempDirectory, id);
        if (!file.exists()) {
            this.log.warn("file package does not exist", (Object)file.getAbsolutePath());
            return null;
        }
        return new FileDistributionPackage(file, this.getType(), null, null);
    }
}

