/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.impl;

import java.util.List;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.impl.SimpleDistributionResponse;
import org.jetbrains.annotations.NotNull;

public class CompositeDistributionResponse
extends SimpleDistributionResponse {
    private final int packagesCount;
    private final long packagseSize;
    private final int queuesCount;
    private final long exportTime;
    private DistributionRequestState state;
    private String message;

    public CompositeDistributionResponse(List<DistributionResponse> distributionResponses, int packagesCount, long packagseSize, long exportTime) {
        super(DistributionRequestState.DISTRIBUTED, null);
        this.packagesCount = packagesCount;
        this.packagseSize = packagseSize;
        this.queuesCount = distributionResponses.size();
        this.exportTime = exportTime;
        if (distributionResponses.isEmpty()) {
            this.state = DistributionRequestState.DROPPED;
        } else {
            this.state = DistributionRequestState.DISTRIBUTED;
            StringBuilder messageBuilder = new StringBuilder("[");
            for (DistributionResponse response : distributionResponses) {
                this.state = this.aggregatedState(this.state, response.getState());
                messageBuilder.append(response.getMessage()).append(", ");
            }
            int lof = messageBuilder.lastIndexOf(", ");
            messageBuilder.replace(lof, lof + 2, "]");
            this.message = messageBuilder.toString();
        }
    }

    @Override
    public boolean isSuccessful() {
        return DistributionRequestState.ACCEPTED.equals((Object)this.state) || DistributionRequestState.DISTRIBUTED.equals((Object)this.state);
    }

    @Override
    @NotNull
    public DistributionRequestState getState() {
        return this.state;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return "CompositeDistributionResponse{isSuccesful=" + this.isSuccessful() + ", state=" + this.state + ", message=" + this.message + '}';
    }

    private DistributionRequestState aggregatedState(DistributionRequestState first, DistributionRequestState second) {
        DistributionRequestState aggregatedState;
        switch (second) {
            case DISTRIBUTED: {
                aggregatedState = first;
                break;
            }
            case ACCEPTED: {
                if (first.equals((Object)DistributionRequestState.DISTRIBUTED)) {
                    aggregatedState = DistributionRequestState.ACCEPTED;
                    break;
                }
                aggregatedState = first;
                break;
            }
            default: {
                aggregatedState = DistributionRequestState.DROPPED;
            }
        }
        return aggregatedState;
    }

    public int getPackagesCount() {
        return this.packagesCount;
    }

    public long getExportTime() {
        return this.exportTime;
    }

    public int getQueuesCount() {
        return this.queuesCount;
    }

    public long getPackagseSize() {
        return this.packagseSize;
    }
}

