/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.common.DistributionException;
import org.jetbrains.annotations.NotNull;

public class PrivilegeDistributionRequestAuthorizationStrategy
implements DistributionRequestAuthorizationStrategy {
    private final String jcrPrivilege;

    public PrivilegeDistributionRequestAuthorizationStrategy(String jcrPrivilege) {
        if (jcrPrivilege == null) {
            throw new IllegalArgumentException("Jcr Privilege is required");
        }
        this.jcrPrivilege = jcrPrivilege;
    }

    @Override
    public void checkPermission(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest) throws DistributionException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session == null) {
            throw new DistributionException("cannot obtain a Session");
        }
        try {
            if (DistributionRequestType.ADD.equals((Object)distributionRequest.getRequestType())) {
                this.checkPermissionForAdd(session, distributionRequest.getPaths());
            } else if (DistributionRequestType.DELETE.equals((Object)distributionRequest.getRequestType())) {
                this.checkPermissionForDelete(session, distributionRequest.getPaths());
            }
        }
        catch (RepositoryException e) {
            throw new DistributionException("Not enough privileges");
        }
    }

    private void checkPermissionForAdd(Session session, String[] paths) throws RepositoryException, DistributionException {
        AccessControlManager acMgr = session.getAccessControlManager();
        Privilege[] privileges = new Privilege[]{acMgr.privilegeFromName(this.jcrPrivilege), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")};
        for (String path : paths) {
            if (acMgr.hasPrivileges(path, privileges)) continue;
            throw new DistributionException("Not enough privileges");
        }
    }

    private void checkPermissionForDelete(Session session, String[] paths) throws RepositoryException, DistributionException {
        AccessControlManager acMgr = session.getAccessControlManager();
        Privilege[] privileges = new Privilege[]{acMgr.privilegeFromName(this.jcrPrivilege), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode")};
        for (String path : paths) {
            String closestParentPath = this.getClosestParent(session, path);
            if (closestParentPath != null && acMgr.hasPrivileges(closestParentPath, privileges)) continue;
            throw new DistributionException("Not enough privileges");
        }
    }

    private String getClosestParent(Session session, String path) throws RepositoryException {
        do {
            if (!session.nodeExists(path)) continue;
            return path;
        } while ((path = Text.getRelativeParent((String)path, (int)1)) != null && path.length() > 0);
        return null;
    }
}

