/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.simple;

import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.impl.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleDistributionQueueProcessor
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionQueue queue;
    private final DistributionQueueProcessor queueProcessor;

    public SimpleDistributionQueueProcessor(DistributionQueue queue, DistributionQueueProcessor queueProcessor) {
        this.queue = queue;
        this.queueProcessor = queueProcessor;
    }

    @Override
    public void run() {
        try {
            DistributionQueueEntry entry;
            while ((entry = this.queue.getHead()) != null) {
                if (this.queueProcessor.process(this.queue.getName(), entry)) {
                    if (this.queue.remove(entry.getId()) == null) continue;
                    this.log.debug("item {} processed and removed from the queue", (Object)entry.getItem());
                    continue;
                }
                this.log.warn("processing of item {} failed", (Object)entry.getId());
            }
        }
        catch (Exception e) {
            this.log.error("error while processing queue {}", (Throwable)e);
        }
    }
}

