/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.jobhandling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.DistributionQueueUtils;
import org.apache.sling.distribution.queue.impl.jobhandling.JobHandlingUtils;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHandlingDistributionQueue
implements DistributionQueue {
    public static final String DISTRIBUTION_QUEUE_TOPIC = "org/apache/sling/distribution/queue";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final String topic;
    private final JobManager jobManager;
    private final boolean isActive;
    private final DistributionQueueType type;

    JobHandlingDistributionQueue(String name, String topic, JobManager jobManager, boolean isActive, DistributionQueueType type) {
        this.name = name;
        this.topic = topic;
        this.jobManager = jobManager;
        this.isActive = isActive;
        this.type = type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public DistributionQueueEntry add(@NotNull DistributionQueueItem item) {
        try {
            Map<String, Object> properties = JobHandlingUtils.createFullProperties(item);
            Job job = this.jobManager.createJob(this.topic).properties(properties).add();
            this.log.debug("job {} added for item {}", (Object)job.getId(), (Object)item.getPackageId());
            return JobHandlingUtils.getEntry(job);
        }
        catch (Exception e) {
            this.log.error("could not add an item to the queue", (Throwable)e);
            return null;
        }
    }

    @Override
    public DistributionQueueEntry getHead() {
        Job firstJob = this.getFirstJob();
        if (firstJob != null) {
            return JobHandlingUtils.getEntry(firstJob);
        }
        return null;
    }

    private Job getFirstJob() {
        this.log.debug("getting first item in the queue");
        List<Job> jobs = this.getJobs(0, 1);
        if (jobs.size() > 0) {
            Job firstItem = jobs.get(0);
            this.log.debug("first item in the queue is {}, retried {} times, state {}", new Object[]{firstItem.getId(), firstItem.getRetryCount(), firstItem.getJobState()});
            return firstItem;
        }
        return null;
    }

    private Job getJob(String itemId) {
        String jobId = JobHandlingUtils.unescapeId(itemId);
        Job job = this.jobManager.getJobById(jobId);
        if (job == null) {
            this.log.warn("item with id {} cannot be found", (Object)itemId);
        } else {
            this.log.debug("retrieved item with id {}, retried {} times, state {}", new Object[]{job.getId(), job.getRetryCount(), job.getJobState()});
        }
        return job;
    }

    private List<Job> getJobs(int skip, int limit) {
        int actualSkip = skip < 0 ? 0 : skip;
        int actualLimit = limit < 0 ? -1 : actualSkip + limit;
        ArrayList<Job> result = new ArrayList<Job>();
        try {
            Collection jobs = this.jobManager.findJobs(JobManager.QueryType.ALL, this.topic, (long)actualLimit, (Map[])null);
            int i = 0;
            for (Job job : jobs) {
                if (i >= actualSkip) {
                    result.add(job);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.log.warn("could not get jobs for topic {}", (Object)this.topic, (Object)e);
        }
        return result;
    }

    @NotNull
    public List<DistributionQueueEntry> getItems(int skip, int limit) {
        ArrayList<DistributionQueueEntry> items = new ArrayList<DistributionQueueEntry>();
        List<Job> jobs = this.getJobs(skip, limit);
        for (Job job : jobs) {
            items.add(JobHandlingUtils.getEntry(job));
        }
        return items;
    }

    @Override
    public DistributionQueueEntry getItem(@NotNull String id) {
        Job job = this.getJob(id);
        if (job != null) {
            return JobHandlingUtils.getEntry(job);
        }
        return null;
    }

    @Override
    public DistributionQueueEntry remove(@NotNull String id) {
        boolean removed = false;
        Job job = this.getJob(id);
        DistributionQueueEntry entry = null;
        if (job != null) {
            entry = JobHandlingUtils.getEntry(job);
            removed = this.jobManager.removeJobById(job.getId());
        }
        this.log.debug("item with id {} removed from the queue: {}", (Object)id, (Object)removed);
        return entry;
    }

    @Override
    @NotNull
    public DistributionQueueStatus getStatus() {
        List<Job> jobs = this.getJobs(0, -1);
        Job firstJob = jobs.size() > 0 ? jobs.get(0) : null;
        DistributionQueueItem firstItem = firstJob != null ? JobHandlingUtils.getItem(firstJob) : null;
        DistributionQueueItemStatus firstItemStatus = firstJob != null ? JobHandlingUtils.getStatus(firstJob) : null;
        DistributionQueueState state = DistributionQueueUtils.calculateState(firstItem, firstItemStatus);
        if (!this.isActive) {
            state = DistributionQueueState.PASSIVE;
        }
        int itemsCount = jobs.size();
        return new DistributionQueueStatus(itemsCount, state);
    }

    @Override
    public DistributionQueueType getType() {
        return this.type;
    }
}

