/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.log.spi.DistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageBuilderProvider;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.DistributionPackageWrapper;
import org.apache.sling.distribution.packaging.impl.SimpleDistributionPackage;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentDistributionPackageExporter
implements DistributionPackageExporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionPackageBuilderProvider packageBuilderProvider;
    private final String name;
    private boolean dropInvalidItems;
    private static final String PACKAGE_TYPE = "agentexporter";
    private DistributionAgent agent;
    private String queueName;

    public AgentDistributionPackageExporter(String queueName, DistributionAgent agent, DistributionPackageBuilderProvider packageBuilderProvider, String name, boolean dropInvalidItems) {
        this.packageBuilderProvider = packageBuilderProvider;
        this.name = name;
        this.dropInvalidItems = dropInvalidItems;
        if (agent == null || packageBuilderProvider == null) {
            throw new IllegalArgumentException("Agent and package builder are required");
        }
        this.queueName = queueName;
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportPackages(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest, @NotNull DistributionPackageProcessor packageProcessor) throws DistributionException {
        if (DistributionRequestType.TEST.equals((Object)distributionRequest.getRequestType())) {
            packageProcessor.process(new SimpleDistributionPackage(distributionRequest, PACKAGE_TYPE));
            return;
        }
        if (!DistributionRequestType.PULL.equals((Object)distributionRequest.getRequestType())) {
            throw new DistributionException("request type not supported " + distributionRequest.getRequestType());
        }
        DistributionPackage distributionPackage = null;
        try {
            this.log.debug("getting packages from queue {}", (Object)this.queueName);
            DistributionQueue queue = this.getQueueOrThrow(this.queueName);
            DistributionQueueEntry entry = queue.getHead();
            if (entry != null) {
                DistributionQueueItem queueItem = entry.getItem();
                DistributionPackageInfo info = DistributionPackageUtils.fromQueueItem(queueItem);
                DistributionPackageBuilder packageBuilder = this.packageBuilderProvider.getPackageBuilder(info.getType());
                if (packageBuilder != null) {
                    distributionPackage = packageBuilder.getPackage(resourceResolver, queueItem.getPackageId());
                    if (distributionPackage != null) {
                        distributionPackage.getInfo().putAll((Map)((Object)info));
                        this.log.debug("item {} fetched from the queue", (Object)info);
                        packageProcessor.process(new AgentDistributionPackage(distributionPackage, queue, entry.getId()));
                    } else if (this.dropInvalidItems) {
                        queue.remove(entry.getId());
                        this.log.warn("ghost package: cannot get package {} dropping from queue", (Object)info);
                    } else {
                        this.log.warn("ghost package: cannot get package {} keeping in queue", (Object)info);
                    }
                } else {
                    this.log.warn("cannot find package builder with type {}", (Object)info.getType());
                }
            }
        }
        finally {
            DistributionPackageUtils.closeSafely(distributionPackage);
        }
    }

    @Override
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String distributionPackageId) {
        try {
            this.log.debug("getting package from queue {}", (Object)this.queueName);
            DistributionQueue queue = this.getQueueOrThrow(this.queueName);
            DistributionQueueEntry entry = queue.getItem(distributionPackageId);
            if (entry != null) {
                DistributionQueueItem queueItem = entry.getItem();
                DistributionPackageInfo info = DistributionPackageUtils.fromQueueItem(queueItem);
                DistributionPackageBuilder packageBuilder = this.packageBuilderProvider.getPackageBuilder(info.getType());
                if (packageBuilder != null) {
                    DistributionPackage distributionPackage = packageBuilder.getPackage(resourceResolver, queueItem.getPackageId());
                    distributionPackage.getInfo().putAll((Map)((Object)info));
                    this.log.debug("item {} fetched from the queue", (Object)info);
                    if (distributionPackage != null) {
                        return new AgentDistributionPackage(distributionPackage, queue, entry.getId());
                    }
                } else {
                    this.log.warn("cannot find package builder with type {}", (Object)info.getType());
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Error exporting package", (Throwable)ex);
        }
        return null;
    }

    private void agentLog(String message, Object[] values) {
        DistributionLog agentLog = this.agent.getLog();
        if (agentLog instanceof DefaultDistributionLog) {
            ((DefaultDistributionLog)agentLog).info(message, values);
        }
    }

    @NotNull
    private DistributionQueue getQueueOrThrow(@NotNull String queueName) throws DistributionException {
        DistributionQueue queue = this.agent.getQueue(queueName);
        if (queue == null) {
            throw new DistributionException(String.format("Could not find queue %s", queueName));
        }
        return queue;
    }

    private class AgentDistributionPackage
    extends DistributionPackageWrapper {
        private final DistributionPackage distributionPackage;
        private final DistributionQueue queue;
        private final String itemId;

        AgentDistributionPackage(DistributionPackage distributionPackage, DistributionQueue queue, String itemId) {
            super(distributionPackage);
            this.distributionPackage = distributionPackage;
            this.queue = queue;
            this.itemId = itemId;
        }

        @Override
        public void delete() {
            this.queue.remove(this.itemId);
            DistributionPackageUtils.releaseOrDelete(this.distributionPackage, this.queue.getName());
            AgentDistributionPackageExporter.this.agentLog("exported package {} with info {} from queue {} by exporter {}", new Object[]{this.itemId, this.distributionPackage.getInfo(), this.queue.getName(), AgentDistributionPackageExporter.this.name});
        }

        @Override
        @NotNull
        public String getId() {
            return this.itemId;
        }
    }
}

